package com.liquidnet.service.goblin.service.impl.inner;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.PageReadListener;
import com.alibaba.fastjson.JSON;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.PhoneDto;
import com.liquidnet.service.goblin.service.manage.IGoblinConsumerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URL;
import java.util.HashMap;

@Slf4j
@Service
public class GoblinConsumerServiceImpl implements IGoblinConsumerService {

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public ResponseDto<Boolean> consumerType12(String finalSkuId, Integer finalType, String xlsPath) {
        try {
            EasyExcel.read(new URL(xlsPath).openStream(), PhoneDto.class, new PageReadListener<PhoneDto>(dataList -> {
                for (PhoneDto data : dataList) {
                    if (data.getMobile() == null) {
                        continue;
                    }
                    String redisKey = GoblinRedisConst.REDIS_CAN_BUY.concat(finalSkuId + ":").concat(data.getMobile());
                    if (finalType.equals(1)) {//添加
                        if (log.isDebugEnabled()) {
                            log.debug("添加 读取到一条数据{}", JSON.toJSONString(data));
                        }
                        redisUtil.set(redisKey, 0);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("删除 读取到一条数据{}", JSON.toJSONString(data));
                        }
                        redisUtil.del(redisKey);
                    }
                }
            })).sheet().doRead();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> consumerType34(String finalSkuId, Integer finalType, String xlsPath, String oXlsPath, String listId) {
        try {
            if (oXlsPath != null && !oXlsPath.equals("")) {//删除旧的黑白名单
                EasyExcel.read(new URL(oXlsPath).openStream(), new PageReadListener<HashMap<String, String>>(dataList -> {
                    for (HashMap<String, String> data : dataList) {
                        if (data.get(0) == null) {
                            continue;
                        }
                        if (finalType.equals(3)) {
                            log.debug("删除 白名单 读取到一条数据{}", JSON.toJSONString(data));
                            redisUtil.del(GoblinRedisConst.REDIS_WHITE.concat(listId + ":").concat(finalSkuId + ":").concat(data.get(0)));
                        } else {
                            log.debug("删除 黑名单 读取到一条数据{}", JSON.toJSONString(data));
                            redisUtil.del(GoblinRedisConst.REDIS_BLACK.concat(listId + ":").concat(finalSkuId + ":").concat(data.get(0)));
                        }
                    }
                })).sheet().doRead();
            }
            if (xlsPath != null && !xlsPath.equals("")) {//添加
                EasyExcel.read(new URL(xlsPath).openStream(), new PageReadListener<HashMap<String, String>>(dataList -> {
                    for (HashMap<String, String> data : dataList) {
                        if (data.get(0) == null) {
                            continue;
                        }
                        if (finalType.equals(3)) {
                            log.debug("添加 白名单 读取到一条数据{}", JSON.toJSONString(data));
                            redisUtil.set(GoblinRedisConst.REDIS_WHITE.concat(listId + ":").concat(finalSkuId + ":").concat(data.get(0)), 1);
                        } else {
                            log.debug("添加 黑名单 读取到一条数据{}", JSON.toJSONString(data));
                            redisUtil.set(GoblinRedisConst.REDIS_BLACK.concat(listId + ":").concat(finalSkuId + ":").concat(data.get(0)), 1);
                        }
                    }
                })).sheet().doRead();
            }
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }
}
