package com.liquidnet.service.reconciliation.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 根据对账单解析出来的实体vo，用户与平台的交易记录对账.
 */
@Data
public class ReconciliationEntityVo implements Cloneable {

	private static final long serialVersionUID = 1L;

	private String id;

	/** 银行类型 CurrencyCloud 、LiquidnetWallet**/
	private String bankChannel;
	/**
	 * ########以下为本地交易信息##########
	 */

	/** 对账批次号 **/
	private String batchNo;

	/** 账单日期 **/
	private Date billDate;

	/**
	 * 订单唯一编号，
	 * 一个订单可能对应多个transactionId，例如：同一个订单号对应充值、下发、换汇、退款(部分退款)
	 */
	private String orderNo;

	/**
	 * 交易唯一id
	 */
	private String transactionId;

	/**
	 * 交易类型 对应取值：TransTypeEnum
	 */
	private String transType;

	private String currency;

	private BigDecimal amount;

	//费用
	private BigDecimal costFee;

	//退款金额
	private BigDecimal refundAmount;

	//交易状态 取值：TransStatusEnum
	private String tradeStatus;

	/**
	 * 银行与本地关联id,有时就是transactionId ，与transType组合为唯一值
	 */
	private String refTransId;

	//该笔交易的对账结果
	private String checkResult;

	/**
	 * ########以下为银行相关交易信息##########
	 */

	/** 下单时间 **/
	private Date orderTime;

	//交易日期
	private Date transDate;

	/** 交易时间 **/
	private Date transTime;

	/** 银行订单号 **/
	private String bankOrderNo;

	/** 银行流水号 **/
	private String bankTrxNo;

	private static final ReconciliationEntityVo obj = new ReconciliationEntityVo();

	public static ReconciliationEntityVo getNew() {
		try {
			return (ReconciliationEntityVo) obj.clone();
		} catch (CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return new ReconciliationEntityVo();
	}
}
