package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * WalletRegisterResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@ApiModel(value = "WalletRegisterResult", description = "Result of wallet registered")
public class WalletRegisterResult extends WalletCallResult<WalletRegisterParam> {
    private static final long serialVersionUID = 4138076964531590827L;
    @ApiModelProperty(position = 11, value = "Wallet user ID [32]")
    private String finId;
    @ApiModelProperty(position = 12, value = "Wallet id [11]")
    private String walletNo;

    public WalletRegisterResult() {
    }

    public WalletRegisterResult(String... arr) {
        this.finId = arr[0];
        this.walletNo = arr[1];
    }

    public WalletRegisterResult(String code, String message) {
        super(code, message);
    }

    public String getFinId() {
        return finId;
    }

    public String getWalletNo() {
        return walletNo;
    }
}
