package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商城订单属性表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderAttr implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单attr_id
     */
    private String orderAttrId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 收货人
     */
    private String expressContacts;

    /**
     * 收货地址[省市区]
     */
    private String expressAddress;

    /**
     * 收货地址[省市区]
     */
    private String expressAddressDetail;

    /**
     * 收货人联系方式
     */
    private String expressPhone;

    /**
     * 快递方式 [1寄付|2到付|3-包邮]
     */
    private Integer expressType;

    /**
     * 发票类型 [0-不需要发票|1增值税普票|2增值税专票]
     */
    private Integer invoiceType;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 发票内容[1-非图书商品|2-明细|3-耗材|4-办公用品]
     */
    private Integer invoiceContent;

    /**
     * 税号
     */
    private String invoiceTaxId;

    /**
     * 单位名称
     */
    private String invoiceCompanyName;

    /**
     * 注册地址
     */
    private String invoiceRegisterAddress;

    /**
     * 注册手机号
     */
    private String invoiceRegisterMobile;

    /**
     * 开户行
     */
    private String invoiceOpenBank;

    /**
     * 银行账号
     */
    private String invoiceBankAccount;

    /**
     * 抬头类型[1-企业|2-个人]
     */
    private Integer invoiceTitleType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 订单的赠品信息格式为JSON
     */
    private String giftInfos;

    /**
     * 捐赠寄语
     */
    private String donationMessage;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
