package com.liquidnet.service.galaxy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 支付通知失败记录
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DragonPayNotifyFail implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单支付编号
     */
    private String code;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 通知url
     */
    private String notifyUrl;

    /**
     * 通知参数
     */
    private String notifyData;

    /**
     * 失败描述
     */
    private String failDesc;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
