package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.dto.vo.admin.SweetIntegralActivityPrizeVo;
import com.liquidnet.service.sweet.service.ISweetIntegralActivityDrawService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 积分活动抽奖记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-26
 */
@Api(tags = "活动-积分抽奖")
@RestController
@RequestMapping("/integralActivityDraw")
public class SweetIntegralActivityDrawController {
    @Autowired
    private ISweetIntegralActivityDrawService activityDrawService;

    @PostMapping("create")
    @ApiOperation("用户抽奖")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "integralActivityId", value = "活动id", required = true)
    })
    public ResponseDto<SweetIntegralActivityPrizeVo> create(
            @RequestParam("integralActivityId") String integralActivityId
    ) {
        return activityDrawService.create(integralActivityId);
    }

    @GetMapping("drawList")
    @ApiOperation("用户(中奖、抽奖)记录列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1中奖记录 2抽奖记录", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "integralActivityId", value = "活动id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "pageNum", value = "分页", required = true)
    })
    public ResponseDto<PagedResult<IntegralActivityDrawVo>> drawList(
            @RequestParam("type") Integer type,
            @RequestParam("integralActivityId") String integralActivityId,
            @RequestParam("pageNum") Integer pageNum
    ) {
        return activityDrawService.drawList(type, integralActivityId, pageNum);
    }

    @GetMapping("winPrizeUser")
    @ApiOperation("活动中奖用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "integralActivityId", value = "活动id", required = true)
    })
    public ResponseDto<List<IntegralActivityDrawVo>> winPrizeUser(
            @RequestParam("integralActivityId") String integralActivityId
    ) {
        return activityDrawService.winPrizeUser(integralActivityId);
    }

    @GetMapping("detail/{drawId}")
    @ApiOperation("抽奖详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "path", dataType = "String", name = "drawId", value = "drawId", required = true)
    })
    public ResponseDto<IntegralActivityDrawVo> detail(
            @PathVariable("drawId") String drawId
    ) {
        return activityDrawService.detail(drawId);
    }

    @PostMapping("perfectAddress")
    @ApiOperation("中奖完善收货地址")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "drawId", value = "中奖ID", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "receivingAddressesId", value = "adam收货地址addresses_id", required = true)
    })
    public ResponseDto perfectAddress(
            @RequestParam("drawId") String drawId,
            @RequestParam("receivingAddressesId") String receivingAddressesId
    ) {
        return activityDrawService.perfectAddress(drawId, receivingAddressesId);
    }

}
