package com.liquidnet.service.merchant.dto.param;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(value = "MerchantFieldApplyParam", description = "认领/创建场地入参")
@Data
public class MerchantFieldApplyParam implements java.io.Serializable {
    private static final long serialVersionUID = 7889390710531228185L;

    @ApiModelProperty(position = 10, required = false, value = "场地ID，认领时必传[50]")
    private String fieldId;

    @ApiModelProperty(position = 11, required = true, value = "场地名称[30]", example = "测试")
    @Size(max = 30, message = "场地长度限制1-30位")
    @NotBlank(message = "名称不能为空")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "logo图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "logo图不能为空")
    private String logo;
    @ApiModelProperty(position = 13, required = true, value = "背景图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "背景图不能为空")
    private String background;
    @ApiModelProperty(position = 14, required = true, value = "介绍[1000]", example = "这是一段介绍文字")
    private String description;
    @ApiModelProperty(position = 15, required = true, value = "建立日期[YYYY-MM-DD]", example = "2021-05-17")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "建立日期格式有误")
    private String builtDate;

    @ApiModelProperty(position = 16, required = true, value = "省id")
    @NotNull(message = "省id不能为null")
    private String provinceId;
    @ApiModelProperty(position = 17, required = true, value = "省名称")
    @NotNull(message = "省名称不能为null")
    private String provinceName;
    @ApiModelProperty(position = 18, required = true, value = "城市id")
    @NotNull(message = "城市id不能为null")
    private String cityId;
    @ApiModelProperty(position = 19, required = true, value = "城市名称")
    @NotNull(message = "城市名称不能为null")
    private String cityName;
    @ApiModelProperty(position = 20, required = true, value = "县id")
    @NotNull(message = "县id不能为null")
    private String districtId;
    @ApiModelProperty(position = 21, required = true, value = "县名称")
    @NotNull(message = "县名称不能为null")
    private String districtName;
    @ApiModelProperty(position = 22, required = true, value = "详细地址[100]", example = "广渠路1号创1958园区")
    @Size(max = 100, message = "已超出详细地址长度限制")
    private String address;
    @ApiModelProperty(position = 23, required = true, value = "经度")
    @NotNull()
    private String longitude;
    @ApiModelProperty(position = 24, required = true, value = "纬度")
    @NotNull()
    private String latitude;

    @ApiModelProperty(position = 25, required = true, value = "联系人姓名", example = "张三")
    @NotNull()
    private String contactName;
    @ApiModelProperty(position = 26, required = true, value = "联系人邮箱", example = "zhangsan@zhengzai.tv")
    @NotNull()
    private String contactEmail;

    @ApiModelProperty(position = 27, required = true, value = "企业名称")
    @NotBlank(message = "企业名称不能为空")
    private String companyName;
    @ApiModelProperty(position = 28, required = true, value = "营业执照编号")
    @NotBlank(message = "营业执照编号不能为空")
    private String licenseCode;
    @ApiModelProperty(position = 29, required = true, value = "营业执照图片")
    @NotBlank(message = "营业执照图片不能为空")
    private String licenseImg;

    @ApiModelProperty(position = 30, required = true, value = "法人姓名", example = "李四")
    @NotBlank(message = "法人姓名不能为空")
    private String legalName;
    @ApiModelProperty(position = 31, required = true, value = "法人身份证号码")
    @Pattern(regexp = LnsRegex.Valid.LETTER_NUMBER, message = "证件号格式有误")
    @Size(min = 1, max = 30, message = "证件号长度限制1-30位")
    @NotBlank(message = "证件号不能为空")
    private String legalIdentity;
    @ApiModelProperty(position = 32, required = true, value = "法人身份证正面照")
    @NotNull(message = "法人身份证正面照不能为空")
    private String legalIdentityObverse;
    @ApiModelProperty(position = 33, required = true, value = "法人身份证反面照")
    @NotNull(message = "法人身份证反面照不能为空")
    private String legalIdentityReverse;
}
