package com.liquidnet.client.admin.web.controller.zhengzai.candy;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.entity.SysRole;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponCodeAdminService;
import com.liquidnet.service.candy.dto.admin.CandyCouponCodeListParam;
import com.liquidnet.service.candy.entity.CandyCouponCode;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Api(tags = "券码管理")
@Slf4j
@Controller
@RequestMapping("candy/coupon/code")
public class CandyCouponCodeAdminController extends BaseController {
    private String prefix = "zhengzai/candy/coupon/code";

    @Autowired
    private ICandyCouponCodeAdminService candyCouponCodeAdminService;

    @RequiresPermissions("candy:coupon:code:view")
    @GetMapping()
    public String role()
    {
        return prefix + "/code";
    }

    @RequiresPermissions("candy:coupon:code:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(CandyCouponCodeListParam listParam)
    {
        startPage();
        LambdaQueryWrapper<CandyCouponCode> lambdaQuery = Wrappers.lambdaQuery(CandyCouponCode.class);
        lambdaQuery.eq(CandyCouponCode::getCouponId, listParam.getCouponId()).eq(CandyCouponCode::getState, listParam.getState());
        List<CandyCouponCode> list = candyCouponCodeAdminService.list(lambdaQuery);
        return getDataTable(list);
    }
}
