package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.config.WechatMpConfigure;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.mp.api.WxMpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 正在 摩登公众号分享
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-20
 */
@Slf4j
@Api(tags = "服务号-分享")
@RestController
@RequestMapping("wechatShareSign")
public class SweetWechatShareController {

    @Autowired
    WechatMpConfigure wechatMpConfigure;

    @GetMapping("/zhengzai")
    @ApiOperation("正在微信分享sign")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "url", value = "url地址 注意 URL 一定要动态获取，不能 hardcode", required = true),
    })
    public ResponseDto<WxJsapiSignature> zhengzai(@RequestParam String url) {
        try {
            WxMpService wxMpService = wechatMpConfigure.getWxMpService(1);
            log.info("zhengzaiShare-isAccessTokenExpired：[{}] ", wxMpService.getWxMpConfigStorage().isAccessTokenExpired());
            log.info("zhengzaiShare-getAccessToken：[{}] ", wxMpService.getWxMpConfigStorage().getAccessToken());
            log.info("zhengzaiShare-isTicketExpired：[{}] ", wxMpService.getWxMpConfigStorage().isTicketExpired(TicketType.JSAPI));
            log.info("zhengzaiShare-Ticket：[{}] ", wxMpService.getWxMpConfigStorage().getTicket(TicketType.JSAPI));
            WxJsapiSignature jsapiSignature = wxMpService.createJsapiSignature(url);
            return ResponseDto.success(jsapiSignature);
        } catch (Exception e) {
            log.error("分享signZhengzaiException", e);
            return ResponseDto.success();
        }
    }

    @GetMapping("/modernsky")
    @ApiOperation("摩登微信分享sign")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "url", value = "url地址 注意 URL 一定要动态获取，不能 hardcode", required = true),
    })
    public ResponseDto<WxJsapiSignature> modernsky(@RequestParam String url) {
        try {
            WxMpService wxMpService = wechatMpConfigure.getWxMpService(2);
            log.info("modernskyShare-isAccessTokenExpired：[{}] ", wxMpService.getWxMpConfigStorage().isAccessTokenExpired());
            log.info("modernskyShare-getAccessToken：[{}] ", wxMpService.getWxMpConfigStorage().getAccessToken());
            log.info("modernskyShare-isTicketExpired：[{}] ", wxMpService.getWxMpConfigStorage().isTicketExpired(TicketType.JSAPI));
            log.info("modernskyShare-Ticket：[{}] ", wxMpService.getWxMpConfigStorage().getTicket(TicketType.JSAPI));
            WxJsapiSignature jsapiSignature = wxMpService.createJsapiSignature(url);
            return ResponseDto.success(jsapiSignature);
        } catch (Exception e) {
            log.error("分享signModernskyException", e);
            return ResponseDto.success();
        }
    }

}
