package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCouponFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponListVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponSpuListVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponBasicVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtExtraService;
import com.liquidnet.service.goblin.service.manage.IGoblinstoreMgtCouponService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class GoblinStoreMgtCouponServiceImpl implements IGoblinstoreMgtCouponService {
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    IGoblinStoreMgtExtraService goblinStoreMgtExtraService;

    @Override
    public PagedResult<GoblinStoreMgtCouponListVo> couponList(GoblinStoreMgtCouponFilterParam filterParam) {
        PagedResult<GoblinStoreMgtCouponListVo> mgtCouponListVoPagedResult = goblinMongoUtils.getMgtStoreCouponListVos(filterParam);
        if (mgtCouponListVoPagedResult.getTotal() > 0) {
            List<GoblinStoreMgtCouponListVo> volist = mgtCouponListVoPagedResult.getList();

        }
        return mgtCouponListVoPagedResult;
    }

    @Override
    public void couponAdd(String uid, GoblinStoreCouponBasicVo storeCouponBasicVo) {
        String storeCouponId = IDGenerator.nextMilliId();
        LocalDateTime now = LocalDateTime.now();

        storeCouponBasicVo.setStoreCouponId(storeCouponId);
        storeCouponBasicVo.setStoreCouponNo(storeCouponId);
        storeCouponBasicVo.setDelFlg("0");
        storeCouponBasicVo.setCreatedAt(now);
        storeCouponBasicVo.setCreatedBy(uid);

        goblinMongoUtils.setMgtStoreCouponBasicVo(storeCouponBasicVo);

        LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
        toMqSqls.add(SqlMapping.get("goblin_store_coupon.insert"));
        LinkedList<Object[]> initStoreCouponObjs = CollectionUtil.linkedListObjectArr();
        initStoreCouponObjs.add(new Object[]{
                storeCouponId, storeCouponBasicVo.getStoreCouponNo(), storeCouponBasicVo.getStoreId(),
                storeCouponBasicVo.getTitle(), storeCouponBasicVo.getLabel(), storeCouponBasicVo.getNotice(),
                storeCouponBasicVo.getType(), storeCouponBasicVo.getStock(), storeCouponBasicVo.getTriggers(),
                storeCouponBasicVo.getValFace(), storeCouponBasicVo.getDiscount(), storeCouponBasicVo.getValOver(),
                storeCouponBasicVo.getValMinus(), storeCouponBasicVo.getDeduction(), storeCouponBasicVo.getReceiveLimit(),
                storeCouponBasicVo.getReceiveCurb(), storeCouponBasicVo.getUseScope(), storeCouponBasicVo.getState(),
                storeCouponBasicVo.getStartTime(), storeCouponBasicVo.getEndTime(), storeCouponBasicVo.getCreatedBy(),
                storeCouponBasicVo.getCreatedAt()
        });
        toMqSqls.add(SqlMapping.get("goblin_store_coupon_rule.insert"));
        LinkedList<Object[]> initStoreCouponRuleObjs = CollectionUtil.linkedListObjectArr();
        if ("1".equals(storeCouponBasicVo.getUseScope()) && !CollectionUtils.isEmpty(storeCouponBasicVo.getSpuIdList())) {// 部分商品
            storeCouponBasicVo.getSpuIdList().forEach(spuId -> initStoreCouponRuleObjs.add(new Object[]{storeCouponId, spuId, uid, now}));
        }

        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                SqlMapping.gets(toMqSqls, initStoreCouponObjs, initStoreCouponRuleObjs));
    }

    @Override
    public GoblinStoreMgtCouponInfoVo couponInfo(String storeId, String storeCouponId) {
        GoblinStoreMgtCouponInfoVo mgtCouponInfoVo = GoblinStoreMgtCouponInfoVo.getNew();
        GoblinStoreCouponVo couponVo = goblinRedisUtils.getStoreCouponVo(storeCouponId);
        if (null != couponVo) {
            mgtCouponInfoVo.setCouponVo(couponVo);
            if ("1".equals(couponVo.getUseScope())) {
                List<String> spuIds = goblinRedisUtils.getStoreCouponSpuIds(storeCouponId);
                if (CollectionUtils.isEmpty(spuIds)) {
                    ArrayList<GoblinStoreMgtCouponSpuListVo> couponSpuListVos = ObjectUtil.getGoblinStoreMgtCouponSpuListVoArrayList();
                    spuIds.forEach(spuId -> {
                        GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(spuId);

                        couponSpuListVos.add(GoblinStoreMgtCouponSpuListVo.getNew().copy(goodsInfoVo));
                    });
                    mgtCouponInfoVo.setSpuVoList(couponSpuListVos);
                }
            }
        }
        return mgtCouponInfoVo;
    }
}
