package com.liquidnet.service.goblin.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinDigitalArtworkInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinDigitalArtworkListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinDigitalArtworkPageVo;
import com.liquidnet.service.goblin.service.IGoblinDigitalArtworkService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@ApiSupport(order = 142000)
@Api(tags = "我的藏品管理")
@Slf4j
@Validated
@RestController
@RequestMapping("artwork")
public class GoblinDigitalArtworkController {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    IGoblinDigitalArtworkService goblinDigitalArtworkService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "藏品列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageNum", value = "索引页数"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "pageSize", value = "显示记录数[默认5，暂定最大也为5]"),
    })
    @PostMapping("list")
    public ResponseDto<GoblinDigitalArtworkPageVo> list(@RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(required = false, defaultValue = "5") Integer pageSize) {
        pageNum = pageNum < 1 ? 1 : pageNum;
        pageSize = pageSize < 1 ? 5 : (pageSize > 5 ? 5 : pageSize);
        String currentUid = CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinDigitalArtworkService.page(currentUid, pageNum, pageSize));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "藏品详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "artworkId", value = "藏品ID"),
    })
    @PostMapping("info")
    public ResponseDto<GoblinDigitalArtworkInfoVo> info(@NotBlank(message = "藏品ID不能为空") @RequestParam String artworkId) {
        return ResponseDto.success(goblinDigitalArtworkService.info(CurrentUtil.getCurrentUid(), artworkId));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "开启盲盒")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "artworkId", value = "藏品ID"),
    })
    @PostMapping("unboxing")
    public ResponseDto<GoblinDigitalArtworkListVo> unboxing(@RequestParam String artworkId) {
        return null;
    }
}
