package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtGoodsSkuExtraFilterParam", description = "商品管理:藏品AR:列表筛选条件")
@Data
public class GoblinStoreMgtGoodsSkuArFilterParam implements Serializable {
    private static final long serialVersionUID = -8520107197264504640L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "当前记录起始索引", example = "1")
    @Min(value = 1, message = "起始索引无效")
    @NotNull(message = "起始索引无效")
    private Integer pageNum;
    @ApiModelProperty(position = 12, required = true, value = "每页显示记录数", example = "20")
    @Min(value = 1, message = "显示记录数不能小于1")
    @Max(value = 100, message = "显示记录数不能大于100")
    @NotNull(message = "显示记录数不能为空")
    private Integer pageSize;
    @ApiModelProperty(position = 13, required = false, value = "搜索关键字[128]")
    @Size(min = 2, max = 100, message = "搜索关键字长度范围2~100")
    private String keyword;
}
