package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * type二维码表
 * </p>
 *
 * @author hujiachen
 * @since 2021-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetQrCode implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * Id
     */
    private String qrCodeId;

    /**
     * 活动type类型
     */
    private Integer type;

    /**
     * 二维码地址
     */
    private String url;

    /**
     * 展示次数
     */
    private Integer showNum;

    /**
     * 访问次数
     */
    private Integer readNum;

    private LocalDateTime createdAt;

    private static final SweetQrCode obj = new SweetQrCode();

    public static SweetQrCode getNew() {
        try {
            return (SweetQrCode) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetQrCode();
        }
    }
}
