package com.liquidnet.service.galaxy.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.SqlMapping;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class GalaxyDataUtils extends AbstractDataUtils{
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private QueueUtil queueUtil;

    static{
        initSqlMapping();
    }

    @Override
    public RedisUtil getRedisUtil() {
        return redisUtil;
    }

    @Override
    public MongoTemplate getMongoTemplate() {
        return mongoTemplate;
    }

    @Override
    public QueueUtil getQueueUtil() {
        return queueUtil;
    }

    public static void initSqlMapping() {
        log.info("初始化initSqlMapping");
        SqlMapping.reloadExtends("galaxy");
    }
}
