package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberRightsCouponRuleVo", description = "会员权益券适用规则")
@Data
public class AdamMemberRightsCouponRuleVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 4282440130223655255L;
    @ApiModelProperty(value = "适用范围[101-音乐节｜102-小型演出(livehouse演出) ｜103-巡演｜100-全场｜90-演出｜91-场次｜92-票｜80-商品｜81-款式]", example = "90")
    private Integer useScope;
    @ApiModelProperty(value = "适用名称", example = "北京草莓")
    private String busiName;
    @ApiModelProperty(value = "适用ID", example = "1")
    private String busiId;

    private static final AdamMemberRightsCouponRuleVo obj = new AdamMemberRightsCouponRuleVo();

    public static AdamMemberRightsCouponRuleVo getNew() {
        try {
            return (AdamMemberRightsCouponRuleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberRightsCouponRuleVo();
        }
    }
}
