package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.entity.KylinLackRegisters;
import com.liquidnet.service.kylin.service.IKylinLackRegistersService;
import com.liquidnet.service.kylin.utils.QueueUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Map;

@Service
public class KylinLackRegistersServiceImpl implements IKylinLackRegistersService {

    @Autowired
    private QueueUtils queueUtils;

    @Override
    public ResponseDto<String> addLackRegister(String performanceId, String ticketId) {
        try {
            KylinLackRegisters lackRegisters = KylinLackRegisters.getNew();
            Map token = CurrentUtil.getTokenClaims();
            lackRegisters.setLackRegistersId(IDGenerator.nextSnowId());
            lackRegisters.setPerformanceId(performanceId);
            lackRegisters.setTicketId(ticketId);
            lackRegisters.setUserId(CurrentUtil.getCurrentUid());
            lackRegisters.setUserName(StringUtils.defaultString(((String) token.get("nickname")), ""));
            lackRegisters.setUserMobile(StringUtils.defaultString(((String) token.get("mobile")), ""));
            lackRegisters.setIpAddress(CurrentUtil.getCliIpAddr());
            lackRegisters.setCreatedAt(LocalDateTime.now());
            queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_PERFORMANCE_LACK.getKey(),SqlMapping.get("kylin_lack_register.insert", lackRegisters.getInsertObj()));
            return ResponseDto.success("登记成功");
        }catch (Exception e){
            e.printStackTrace();
            return ResponseDto.success("登记失败");
        }
    }
}
