package com.liquidnet.service.sweet.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class IntegralActivityDrawVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -6777064807434774549L;

    @ApiModelProperty(value = "抽奖id")
    private String drawId;

    @ApiModelProperty(value = "关联活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "活动玩一次所需积分")
    private Integer activityNum;

    @ApiModelProperty(value = "关联奖品id")
    private String prizeId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品类型 1谢谢惠顾 2积分 3代金券 4满减券 5优先购买券 6实物")
    private Integer prizeType;

    @ApiModelProperty(value = "关联id 如商品id 券id")
    private String relationId;

    @ApiModelProperty(value = "单次奖励数量如积分 中奖给多少")
    private Integer prizeTypeNum;

    @ApiModelProperty(value = "关联用户id")
    private String userId;

    @ApiModelProperty(value = "关联用户昵称")
    private String nickname;

    @ApiModelProperty(value = "adam收货地址addresses_id")
    private String receivingAddressesId;

    @ApiModelProperty(value = "adam收货人姓名")
    private String receivingName;

    @ApiModelProperty(value = "adam收货人手机号")
    private String receivingPhone;

    @ApiModelProperty(value = "adam收货人完整地址 空格隔离省市区详细地址")
    private String receivingAddress;

    @ApiModelProperty(value = "收货状态 1中奖未发放 2已发放")
    private Integer receivingStatus;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final IntegralActivityDrawVo obj = new IntegralActivityDrawVo();
    public static IntegralActivityDrawVo getNew() {
        try {
            return (IntegralActivityDrawVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityDrawVo();
        }
    }

    public IntegralActivityDrawVo copy(SweetIntegralActivityDraw source) {
        if (null == this) return this;
        this.setDrawId(source.getDrawId());
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setActivityNum(source.getActivityNum());
        this.setPrizeId(source.getPrizeId());
        this.setPrizeTitle(source.getPrizeTitle());
        this.setPrizeType(source.getPrizeType());
        this.setPrizeTypeNum(source.getPrizeTypeNum());
        this.setRelationId(source.getRelationId());
        this.setUserId(source.getUserId());
        this.setNickname(source.getNickname());
        this.setReceivingAddressesId(source.getReceivingAddressesId());
        this.setReceivingName(source.getReceivingName());
        this.setReceivingPhone(source.getReceivingPhone());
        this.setReceivingAddress(source.getReceivingAddress());
        this.setReceivingStatus(source.getReceivingStatus());
        this.setCreatedAt(source.getUpdatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
