package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinOrderRefundsServiceImpl;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dao.OrderRefundDao;
import com.liquidnet.service.kylin.dto.param.RefundApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.dto.param.RefundSearchParam;
import com.liquidnet.service.kylin.dto.vo.KylinOrderRefundsVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 后台单订单退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 10:58 上午
 */

@Controller
@RequestMapping("/kylin/refund")
public class KylinOrderRefundAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/refund";

    @Autowired
    private KylinOrderRefundsServiceImpl kylinOrderRefundsServiceImpl;

    @RequiresPermissions("kylin:refund:view")
    @GetMapping()
    public String refund() {
        return prefix + "/refund";
    }

    @GetMapping("callback")
    public String refundCallback(@RequestBody RefundCallbackParam refundCallbackParam) {
        String result = kylinOrderRefundsServiceImpl.refundCallback(refundCallbackParam);
        return result;
    }

    @RequiresPermissions("kylin:refund:detail")
    @GetMapping(value = "/details/{orderRefundId}")
    public String detail(@PathVariable("orderRefundId") String orderRefundId, ModelMap mmap) {
        KylinOrderRefundsVo result = null;
        result = kylinOrderRefundsServiceImpl.detail(orderRefundId);
        mmap.put("KylinOrderRefundsVo", result);
        return prefix + "/details";
    }

    @RequiresPermissions("kylin:refund:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo refundList(RefundSearchParam refundSearchParam) {
        PageInfo<OrderRefundDao> result = kylinOrderRefundsServiceImpl.refundList(refundSearchParam);
        return getDataTable(result.getList());
    }

    @RequiresPermissions("kylin:refund:apply")
    @PostMapping("apply")
    @ResponseBody
    public AjaxResult refundApply(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundApply(refundApplyParam);
            if (res) {
                return success();
            } else {
                return error("申请退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refund:cancel")
    @PostMapping("cancel")
    @ResponseBody
    public AjaxResult refundCancel(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundCancel(refundApplyParam);
            if (res) {
                return success();
            } else {
                return error("取消退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refund:reapply")
    @PostMapping("reapply")
    @ResponseBody
    public AjaxResult refundReapply(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundReapply(refundApplyParam);
            if (res) {
                return success();
            } else {
                // 不是重新发起退款，而是重新发起退款审核
                return error("再次发起退款审核失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    // 一审
    @RequiresPermissions("kylin:refund:review")
    @PostMapping("review")
    @ResponseBody
    public AjaxResult refundReview(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = false;
            Integer status = refundApplyParam.getStatus();
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_APPROVED) { // 通过
                res = kylinOrderRefundsServiceImpl.refundApproved(refundApplyParam);
            }
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_REJECT) { // 驳回
                res = kylinOrderRefundsServiceImpl.refundReject(refundApplyParam);
            }
            if (res) {
                return success();
            } else {
                return error("审核退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    // 二审
    @RequiresPermissions("kylin:refund:execute")
    @PostMapping("execute")
    @ResponseBody
    public AjaxResult refundExecute(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = false;
            Integer status = refundApplyParam.getStatus();
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_UNFILLED) { // 通过
                res = kylinOrderRefundsServiceImpl.refundUnfilled(refundApplyParam);
            }
            if (status == KylinTableStatusConst.ORDER_REFUND_STATUS_REFUSE) { // 驳回
                res = kylinOrderRefundsServiceImpl.refundRefuse(refundApplyParam);
            }
            if (res) {
                return success();
            } else {
                return error("审核退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    // 主动完成退款
    @RequiresPermissions("kylin:refund:completed")
    @PostMapping("completed")
    @ResponseBody
    public AjaxResult refundCompleted(RefundApplyParam refundApplyParam) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundCompleted(refundApplyParam);
            if (res) {
                return success();
            } else {
                return error("关闭订单失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

}
