package com.liquidnet.client.admin.web.controller.zhengzai;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * 用户Controller
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
@Controller
@RequestMapping("local")
public class LocalAdminController extends BaseController
{
    private final String stonePrefix = "zhengzai/stone";
    private final String storePrefix = "zhengzai/store";

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    @GetMapping("/integralList")
    public String integralList()
    {
        return stonePrefix + "/integralList";
    }
    @GetMapping("/integralStore")
    public String integralStore()
    {
        return stonePrefix + "/integralStore";
    }
    @GetMapping("/LuckyDraw")
    public String LuckyDraw()
    {
        return stonePrefix + "/LuckyDraw";
    }
    @GetMapping("/integralOrder")
    public String integralOrder()
    {
        return stonePrefix + "/integralOrder";
    }
    @GetMapping("/integralDetail")
    public String integralDetail()
    {
        return stonePrefix + "/integralDetail";
    }
    @GetMapping("/shopList")
    public String shopList()
    {
        return storePrefix + "/shopManage/shopList";
    }
    @GetMapping("/shopDetail")
    public String shopDetail()
    {
        return storePrefix + "/shopManage/shopDetail";
    }
    @GetMapping("/storeClassify")
    public String storeClassify()
    {
        return storePrefix + "/storeClassify/index";
    }
    @GetMapping("/MusicTagStore")
    public String MusicTagStore()
    {
        return storePrefix + "/MusicTagStore/index";
    }
    @GetMapping("/tagStore")
    public String tagStore()
    {
        return storePrefix + "/tagStore/index";
    }
    @GetMapping("/activityList")
    public String activityList()
    {
        return storePrefix + "/placingOrder/activityList";
    }
    @GetMapping("/addNewActivity")
    public String addNewActivity()
    {
        return storePrefix + "/placingOrder/addNewActivity";
    }
    @GetMapping("/activityStoreList")
    public String activityStoreList()
    {
        return storePrefix + "/placingOrder/activityStoreList";
    }
    @GetMapping("/storeDetail")
    public String storeDetail()
    {
        return storePrefix + "/placingOrder/storeDetail";
    }
    @GetMapping("/setGoodsRole")
    public String setGoodsRole()
    {
        return storePrefix + "/placingOrder/setGoodsRole";
    }
    @GetMapping("/selectGoddsTab")
    public String selectGoddsTab()
    {
        return storePrefix + "/placingOrder/selectGoddsTab";
    }
    @GetMapping("/homeSet")
    public String homeSet(ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return storePrefix + "/homeSet/index";
    }
    @GetMapping("/searchStore")
    public String searchStore()
    {
        return storePrefix + "/homeSet/searchStore";
    }
    @GetMapping("/topBanner")
    public String topBanner(ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return storePrefix + "/homeSet/topBanner";
    }
    @GetMapping("/kingArea")
    public String kingArea(ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return storePrefix + "/homeSet/kingArea";
    }
    @GetMapping("/RubikArea")
    public String RubikArea()
    {
        return storePrefix + "/homeSet/RubikArea";
    }
    @GetMapping("/carefullyGoods")
    public String carefullyGoods()
    {
        return storePrefix + "/homeSet/carefullyGoods";
    }
    @GetMapping("/goodsIntersection")
    public String goodsIntersection()
    {
        return storePrefix + "/goodsIntersection/index";
    }
    @GetMapping("/newRecommended")
    public String newRecommended()
    {
        return storePrefix + "/homeSet/newRecommended";
    }

}
