package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNtfUploadReqDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/12 00:09
 */
@ApiModel(value = "GalaxyNftUploadReqDto", description = "NFT素材上传")
@Data
public class GalaxyNftUploadReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "nft原始素材url")
    private String originalNftUrl;

    @ApiModelProperty(position = 1, required = true, value = "显示图原始素材url")
    private String originalDisplayUrl;

    @ApiModelProperty(position = 2, required = true, value = "商品唯一规格ID")
    private String skuId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftUploadReqDto obj = new GalaxyNftUploadReqDto();

    public static GalaxyNftUploadReqDto getNew() {
        try {
            return (GalaxyNftUploadReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftUploadReqDto();
        }
    }
}