package com.liquidnet.service.adam.controller;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dypnsapi.model.v20170525.GetMobileRequest;
import com.aliyuncs.dypnsapi.model.v20170525.GetMobileResponse;
import com.aliyuncs.exceptions.ClientException;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.core.JwtValidator;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamLoginInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.service.*;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.DigestUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiSupport(order = 10010)
@Api(tags = "用户登录")
@Slf4j
@RestController
@RequestMapping("")
public class AdamLoginController {
    @Autowired
    Environment env;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    JwtValidator jwtValidator;
    @Autowired
    DefaultAcsClient defaultAcsClient;
    @Autowired
    IAdamUserService adamUserService;
    @Autowired
    IAdamRealNameService adamRealNameService;
    @Autowired
    IAdamThirdPartyService adamThirdPartyService;
    @Autowired
    IAdamUserMemberService adamUserMemberService;
    @Autowired
    IAdamMemberService adamMemberService;
    @Autowired
    IAdamRdmService adamRdmService;

    /*@ApiOperationSupport(order = 1)
    @ApiOperation(value = "手机号密码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "password", value = "密码"),
    })
    @PostMapping(value = {""})
    public ResponseDto<AdamLoginInfoVo> loginByPwd(@RequestParam String mobile, @RequestParam String password) {
        log.info("mobile:{},pwd:{}", mobile, password);
        DigestUtils.md5DigestAsHex((password + "salt_").getBytes(StandardCharsets.UTF_8));


        return ResponseDto.success(AdamLoginInfoVo.getNew());
    }*/

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "发送验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
    })
    @GetMapping(value = {"send"})
    public ResponseDto<Object> sendSms(@RequestParam String mobile) {
        log.info("send to mobile:{}", mobile);

        LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
        paramsMap.add("mobile", mobile);
        LinkedMultiValueMap<String, String> headersMap = new LinkedMultiValueMap<>();
        headersMap.add("token", null);

        try {
            // TODO: 2021/5/12
            String respStr = HttpUtil.post("https://service.zhengzai.tv/smsCode", paramsMap, headersMap);
            log.info("###PHP.API[{}].RESP[{}]", "https://service.zhengzai.tv/smsCode", respStr);

//            Map respMap = JsonUtils.fromJson(respStr, Map.class);

        } catch (Exception e) {
            log.error("验证码发送异常[mobile:{}]", mobile, e);
            return ResponseDto.failure(ErrorMapping.get("10001"));
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "手机号验证码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping(value = {"login/sms"})
    public ResponseDto<AdamLoginInfoVo> loginBySms(@RequestParam String mobile, @RequestParam String code) {
        // TODO: 2021/5/12 参数检验
        log.info("mobile:{},code:{}", mobile, code);

        if (!this.checkSmsCode(mobile, code)) return ResponseDto.failure(ErrorMapping.get("10002"));

        String uid = adamRdmService.getUidByMobile(mobile);
        AdamUserInfoVo userInfoVo =
                StringUtils.isEmpty(uid) ? adamUserService.register(mobile) : adamRdmService.getUserInfoVoByUid(uid);
        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
//        if (userInfoVo.getIsComplete() == 1) {
            loginInfoVo.setRealNameInfo(adamRdmService.getRealInfoVoByUid(userInfoVo.getUid()));
            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(userInfoVo.getUid()));
            loginInfoVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(userInfoVo.getUid()));
            loginInfoVo.setMemberSimpleVo(adamRdmService.getMemberSimpleVo());
//        }
        loginInfoVo.setUserInfo(userInfoVo);
        loginInfoVo.setToken(this.ssoProcess(userInfoVo));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "手机号一键登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "accessToken", value = "访问令牌"),
    })
    @PostMapping(value = {"login/mobile"})
    public ResponseDto<AdamLoginInfoVo> loginByMobile(@RequestParam String accessToken) {
        // TODO: 2021/5/10
        log.info("login by mobile access token:{}", accessToken);

        String mobile = this.getMobile(accessToken);
        if (StringUtils.isEmpty(mobile)) return ResponseDto.failure(ErrorMapping.get("10005"));

        String uid = adamRdmService.getUidByMobile(mobile);
        AdamUserInfoVo userInfoVo =
                StringUtils.isEmpty(uid) ? adamUserService.register(mobile) : adamRdmService.getUserInfoVoByUid(uid);
        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
//        if (loginInfoVo.getUserInfo().getIsComplete() == 1) {
            loginInfoVo.setRealNameInfo(adamRdmService.getRealInfoVoByUid(userInfoVo.getUid()));
            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(userInfoVo.getUid()));
            loginInfoVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(userInfoVo.getUid()));
            loginInfoVo.setMemberSimpleVo(adamRdmService.getMemberSimpleVo());
//        }
        loginInfoVo.setUserInfo(userInfoVo);
        loginInfoVo.setToken(this.ssoProcess(userInfoVo));
        return ResponseDto.success(AdamLoginInfoVo.getNew());
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "第三方账号登录")
    @PostMapping(value = {"login/tpa"})
    public ResponseDto<AdamLoginInfoVo> loginByTpa(@RequestBody AdamThirdPartParam parameter) {
        // TODO: 2021/5/10
        log.info("login by tpa:{}", JsonUtils.toJson(parameter));

        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (StringUtils.isEmpty(parameter.getMobile())) {
            String uid = adamRdmService.getUidByPlatformOpenId(parameter.getPlatform(), parameter.getOpenId());
            if (StringUtils.isEmpty(uid)) return ResponseDto.failure(ErrorMapping.get("10006"));

            loginInfoVo.setUserInfo(adamRdmService.getUserInfoVoByUid(uid));
            loginInfoVo.setRealNameInfo(adamRdmService.getRealInfoVoByUid(uid));
            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(uid));
            loginInfoVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(uid));
            loginInfoVo.setMemberSimpleVo(adamRdmService.getMemberSimpleVo());
        } else {// 新账号注册
            if (!this.checkSmsCode(parameter.getMobile(), parameter.getCode()))
                return ResponseDto.failure(ErrorMapping.get("10002"));

            AdamUserInfoVo registerUserInfo = adamUserService.register(parameter);
            loginInfoVo.setUserInfo(registerUserInfo);
            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(registerUserInfo.getUid()));
            loginInfoVo.setMemberSimpleVo(adamRdmService.getMemberSimpleVo());
        }
        loginInfoVo.setToken(this.ssoProcess(loginInfoVo.getUserInfo()));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "登出")
    @PostMapping(value = {"out"})
    public void logout() {
        log.info("###logout:uid:{}\ntoken:{}", CurrentUtil.getCurrentUid(), CurrentUtil.getToken());

        redisUtil.del(jwtValidator.getSsoRedisKey().concat(CurrentUtil.getCurrentUid()));
    }

    @ApiOperationSupport(order = 7)
    @ApiOperation(value = "注销")
    @PostMapping(value = {"close"})
    public ResponseDto<Object> close() {
        log.info("###close:uid:{}", CurrentUtil.getCurrentUid());

        adamUserService.close(CurrentUtil.getCurrentUid());

        this.logout();

        return ResponseDto.success();
    }

    /* ---------------------------- Internal Method ---------------------------- */

    private boolean checkSmsCode(String mobile, String code) {
        if (Arrays.asList("dev", "test").contains(env.getProperty("spring.profiles.active"))) {
            return "111111".equals(code);
        }

        LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
        paramsMap.add("mobile", mobile);
        paramsMap.add("code", code);
        LinkedMultiValueMap<String, String> headersMap = new LinkedMultiValueMap<>();
        headersMap.add("token", null);

        try {
            // TODO: 2021/5/12
            String respStr = HttpUtil.get("https://service.zhengzai.tv/smsValidation", paramsMap, headersMap);
            log.info("###PHP.API.RESP:{}", respStr);

            Map respMap = JsonUtils.fromJson(respStr, Map.class);

            return StringUtils.equalsIgnoreCase("OK", (String) respMap.get("message"));
        } catch (Exception e) {
            log.error("验证码验证异常[mobile:{},code:{}]", mobile, code, e);
            return false;
        }
    }

    private String getMobile(String accessToken) {
        try {
            GetMobileRequest request = new GetMobileRequest();
            request.setAccessToken(accessToken);

            GetMobileResponse response = defaultAcsClient.getAcsResponse(request);

            if (!Objects.isNull(response) && response.getCode().equalsIgnoreCase("OK")) {
                return response.getGetMobileResultDTO().getMobile();
            }
        } catch (ClientException e) {
            log.error("error:aliyun.dypns.api:{}", accessToken, e);
        }
        return null;
    }

    private String ssoProcess(AdamUserInfoVo userInfoVo) {
        Map<String, Object> claimsMap = new HashMap<>();
        claimsMap.put("sub", userInfoVo.getUid());
        // TODO: 2021/5/25 修改手机号更新TOKEN
        claimsMap.put("mobile", userInfoVo.getMobile());
        claimsMap.put("nickname", userInfoVo.getNickname());
        claimsMap.put("type", "user");

        String token = jwtValidator.create(claimsMap);

        redisUtil.set(
                jwtValidator.getSsoRedisKey().concat(userInfoVo.getUid()),
                DigestUtils.md5DigestAsHex(token.getBytes(StandardCharsets.UTF_8)),
                jwtValidator.getExpireTtl() * 60
        );

        return token;
    }
}
