package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserDigitalArtworkVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5920952408993245963L;
    private String artworkId;
    private String uid;
    private String skuId;
    private String orderId;
    private Integer editionSn;
    private String nftId;
    private String releaseTxhash;
    private String releaseAt;
    private String tradingTxhash;
    private String tradingAt;
    private String transferOrderId;
    private String transferState;
    private Integer source;
    private Integer state;
    private String delFlg;
    private LocalDateTime openingAt;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
    private LocalDateTime deletedAt;

    /* ---------------------- 冗余的关联信息 ---------------------- */
    private String author;
    private String publisher;
    private String transferUser;
    private String hitArtworkId;

    private static final GoblinUserDigitalArtworkVo obj = new GoblinUserDigitalArtworkVo();

    public static GoblinUserDigitalArtworkVo getNew() {
        try {
            return (GoblinUserDigitalArtworkVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserDigitalArtworkVo();
        }
    }
}
