package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.param.GoblinMixDetailsParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode
public class GoblinMixAppListVo implements Serializable, Cloneable {
    @ApiModelProperty(position = 0, value = "活动id")
    private String mixId;
    @ApiModelProperty(position = 1, value = "活动名称")
    private String name;
    @ApiModelProperty(position = 2, value = "活动名称")
    private String sellName;
    @ApiModelProperty(position = 3, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 4, value = "状态[6-活动中|7-停用|8-售罄|9-等待开始|10-活动结束]")
    private Integer status;
    @ApiModelProperty(position = 5, value = "开始时间")
    private String timeStart;
    @ApiModelProperty(position = 6, value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(position = 7, value = "销售价格")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 8, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(position = 9, value = "活动创建时间")
    private String createdAt;
    @ApiModelProperty(position = 10,value = "当前时间")
    private String nowTime;
    @ApiModelProperty(position = 22, value = "上架时间")
    private String shelvesTime;
    @ApiModelProperty(position = 23, value = "预约开启标识[0:未开启，1开启]")
    private int reserve;

    private static final GoblinMixAppListVo obj = new GoblinMixAppListVo();

    public static GoblinMixAppListVo getNew() {
        try {
            return (GoblinMixAppListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixAppListVo();
        }
    }

    public GoblinMixAppListVo copy(GoblinMixDetailsVo source,String nowTime) {
        if (null == source) return this;
        this.setMixId(source.getMixId());
        this.setName(source.getName());
        this.setSellName(source.getSellName());
        this.setCoverPic(source.getCoverPic());
        this.setTimeStart(source.getTimeStart());
        this.setTimeEnd(source.getTimeEnd());
        this.setSellPrice(source.getSellPrice());
        this.setPrice(source.getPrice());
        this.setCreatedAt(source.getCreatedAt());
        this.setShelvesTime(source.getShelvesTime());
        this.setNowTime(nowTime);
        this.setReserve(source.getReserve());
        return this;
    }
}
