package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel
@Data
public class KylinCandyParam implements Serializable, Cloneable {

    @ApiModelProperty(value = "券id集合")
    private List<KylinCandyItemParam> couponList;
    @ApiModelProperty(value = "巡演id")
    private String roadShowId;

    private static final KylinCandyParam obj = new KylinCandyParam();

    public static KylinCandyParam getNew() {
        try {
            return (KylinCandyParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinCandyParam();
        }
    }

}
