package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinSelfExtagVo", description = "音乐人、艺人、IP信息")
@Data
public class GoblinSelfExtagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 367926424789690081L;
    @ApiModelProperty(position = 10, value = "标签ID")
    private String tagId;
    @ApiModelProperty(position = 11, value = "标签名称")
    private String tagName;
    @ApiModelProperty(position = 12, value = "排序[数值越小,排序越前]")
    private Integer sort;
    @ApiModelProperty(position = 13, value = "标签说明")
    private String tagDesc;
    @ApiModelProperty(position = 14, value = "标签图片")
    private String tagPic;

    private static final GoblinSelfExtagVo obj = new GoblinSelfExtagVo();
    public static GoblinSelfExtagVo getNew() {
        try {
            return (GoblinSelfExtagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSelfExtagVo();
        }
    }
}
