package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStorePurchaseSkuVo", description = "限时秒杀活动-商品SkuVo")
@Data
public class GoblinStorePurchaseSkuVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 8425727558228094904L;
    @ApiModelProperty(position = 0, value = "单品规格信息")
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 1, value = "marketSkuId")
    private String marketSkuId;
    @ApiModelProperty(position = 1, value = "总库存")
    private Integer stock;
    @ApiModelProperty(position = 2, value = "可配置库存")
    private Integer skuStock;
    @ApiModelProperty(position = 3, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(position = 4, value = "秒杀价")
    private BigDecimal priceMarketing;
    @ApiModelProperty(position = 5, value = "库存数量")
    private Integer stockMarketing;
    @ApiModelProperty(position = 6, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;
    @ApiModelProperty(position = 7, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    private Integer buyFactor;
    @ApiModelProperty(position = 8, value = "购买限制人员名单[购买限制为2-指定用户时必填]")
    private Integer buyRoster;



    private static final GoblinStorePurchaseSkuVo obj = new GoblinStorePurchaseSkuVo();

    public static GoblinStorePurchaseSkuVo getNew() {
        try {
            return (GoblinStorePurchaseSkuVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStorePurchaseSkuVo();
        }
    }
}
