package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 平台专属标签
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinSelfExtag implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 标签id
     */
    private String tagId;

    /**
     * 标签名称
     */
    private String tagName;

    /**
     * 标签描述
     */
    private String tagDesc;

    /**
     * 标签图片
     */
    private String tagPic;

    /**
     * 标签类型[1-音乐人|2-艺术家|3-IP]
     */
    private String tagType;

    /**
     * 排序[数值越小,排序越前]
     */
    private Integer sort;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String comment;


}
