package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.service.impl.KylinPerformancesServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: KylinMyPerformancesController
 * @Package com.liquidnet.service.kylin.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/12 13:34
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("myPerformance")
@Slf4j
public class KylinMyPerformancesController {
    @Autowired
    private KylinPerformancesServiceImpl kylinPerformancesService;

    @GetMapping("performancesList")
    @ApiOperation("我的已购票演出列表")
    public ResponseDto<List<KylinPerformanceVo>> performancesList() {
        List<KylinPerformanceVo> result = kylinPerformancesService.myPerformancesList();
        return ResponseDto.success(result);
    }


    @GetMapping("getDetail")
    @ApiOperation("演出详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "path", dataType = "String", name = "performancesId", value = "演出id", required = true)
    })
    public ResponseDto<KylinPerformanceVo> getDetail(
            @RequestParam("performancesId") String performancesId
    ) {
        try {
            KylinPerformanceVo result = kylinPerformancesService.detail(performancesId, 0, 0, "0");
            if (result != null) {
                return ResponseDto.success(result);
            } else {
                return ResponseDto.failure(ErrorMapping.get("20700"));
            }
        } catch (Exception e) {
            log.error("演出详情Error", e);
            return ResponseDto.failure(ErrorMapping.get("20700"));
        }
    }
}
