package com.liquidnet.service.platform.controller.goblin.task;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.platform.service.impl.goblin.PlatformGoblinGoodsService;
import com.liquidnet.service.platform.service.impl.goblin.PlatformGoblinGoodsSkuService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 商城商品任务处理
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/1/21
 */
@Slf4j
@RestController
@RequestMapping("ggoods/task")
public class PlatformGoblinGoodsTaskController {
    @Autowired
    private PlatformGoblinGoodsService platformGoblinGoodsService;
    @Autowired
    private PlatformGoblinGoodsSkuService platformGoblinGoodsSkuService;

    @PutMapping("onshelves")
    public ResponseDto<String> ggoodsOnShelvesHandler() {
        int spuCount = 0, skuCount = 0;
        boolean spuShelvesFlg = true, skuShelvesFlg = true;

        {// 普通商品上架处理
            List<GoblinGoods> shelvesSpuList = platformGoblinGoodsService.shelvesInquiry();
            if (!CollectionUtils.isEmpty(shelvesSpuList)) {
                spuCount += shelvesSpuList.size();
                List<String> shelvesSpuIdList = shelvesSpuList.stream().map(GoblinGoods::getSpuId).collect(Collectors.toList());
                try {
                    platformGoblinGoodsService.shelvesProcessing(shelvesSpuIdList);
                } catch (Exception e) {
                    log.error("Ex.商品上架处理[totalCount={},spuIdList={}],{}", spuCount, JsonUtils.toJson(shelvesSpuIdList), e.getMessage());
                    spuShelvesFlg = false;
                }
            }
        }
        {// 数字藏品上架处理
            List<GoblinGoodsSku> shelvesSkuList = platformGoblinGoodsSkuService.shelvesInquiry();
            if (!CollectionUtils.isEmpty(shelvesSkuList)) {
                skuCount += shelvesSkuList.size();
                List<String> shelvesSkuIdList = shelvesSkuList.stream().map(GoblinGoodsSku::getSkuId).collect(Collectors.toList());
                List<String> shelvesSpuIdList = shelvesSkuList.stream().map(GoblinGoodsSku::getSpuId).collect(Collectors.toList());
                try {
                    platformGoblinGoodsSkuService.shelvesProcessing(shelvesSkuIdList, shelvesSpuIdList);
                } catch (Exception e) {
                    log.error("Ex.藏品上架处理[skuCount={},skuIdList={}],{}", skuCount, JsonUtils.toJson(shelvesSkuIdList), e.getMessage());
                    skuShelvesFlg = false;
                }
            }
        }

        return ResponseDto.success(String.format("商品上架处理[spuCount=%s:%s;skuCount=%s:%s]", spuCount, spuShelvesFlg, skuCount, skuShelvesFlg));
    }
}
