package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodAnticipateUserVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import com.liquidnet.service.goblin.util.GoblinAnticipateUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 预约表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Service
@Slf4j
public class GoblinGoodsAnticipateServiceImpl implements IGoblinGoodsAnticipateService {


    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @Autowired
    QueueUtils queueUtils;

    @Autowired
    GoblinAnticipateUtils goblinAnticipateUtils;

    @Override
    public ResponseDto<Object> userAbout(String skuId) {
        //查询该skuId是否能被预约
        GoblinGoodsAnticipateValueVo anticipateValueVo = goblinRedisUtils.getValueBySkuId(skuId);
        if (anticipateValueVo != null) {
            anticipateValueVo.setState(GoblinAnticipateUtils.setState(anticipateValueVo.getAboutStartDate(), anticipateValueVo.getAboutEndDate()));
            if (!anticipateValueVo.getState().equals(1)) {
                return ResponseDto.failure("该商品预约尚未开始或已经结束，不可预约！");
            }
            //查询该用户是否预
            String uid = CurrentUtil.getCurrentUid();
            GoblinGoodAnticipateUserVo userVo = goblinRedisUtils.getUserAboutAut(skuId, uid);
            LinkedList<Object[]> sqlValue = CollectionUtil.linkedListObjectArr();
            if (userVo == null) {
                GoblinGoodAnticipateUserVo user = new GoblinGoodAnticipateUserVo();
                user.setUid(uid);
                user.setSkuId(skuId);
                String mobile = StringUtils.defaultString(((String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_MOBILE)), "");
                user.setPhone(mobile);
                user.setState(0);
                user.setCreatedDate(LocalDateTime.now());
                //mongodb记录
                goblinRedisUtils.setUserAboutSku(user);
                //用户没有预约过
                //发送redis消息修改mysql记录用户预约
                sqlValue.add(new Object[]{
                        user.getUid(),
                        skuId,
                        user.getPhone(),
                        0,
                        user.getCreatedDate()
                });
                sendRedis("goblin_goods_anticipate_user", sqlValue);
                goblinRedisUtils.setSkuIdPeople(skuId);
                //获取用户头像个数小于等于2则保存用户头像
                List<String> userAvatar = goblinRedisUtils.getUserAvatar(skuId);
                if (userAvatar != null && userAvatar.size() <= 2) {
                    //查询用户信息获取用户头像并保存
                    AdamUserInfoVo userInfo = goblinAnticipateUtils.getUserInfo();
                    goblinRedisUtils.setUserAvatar(skuId, userInfo.getAvatar());
                }
            }
            return ResponseDto.success();
        }
        return ResponseDto.failure("该预约不存在！");
    }

    @Override
    public ResponseDto<Boolean> selectAnticipate(String skuId) {
        String uid = CurrentUtil.getCurrentUid();
        return ResponseDto.success(goblinRedisUtils.getUserAboutAut(skuId, uid) != null);
    }

    public void sendRedis(String sqlKey, LinkedList<Object[]> sqlData) {
        LinkedList<String> sql = CollectionUtil.linkedListString();
        sql.add(SqlMapping.get(sqlKey));
        String sqlStr = SqlMapping.gets(sql, sqlData);
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_MARKET.getKey(),
                sqlStr);
    }

}
