package com.liquidnet.service.platform.utils;

import com.liquidnet.commons.lang.util.CollectionUtil;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Component
public class QueueUtils {

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 发送 SqlMapping Json 字符串
     *
     * @param exchange 交换机
     * @param route    路径
     * @param sqlStr   Json字符串
     */
    public void sendSqlRabbit(String exchange, String route, String sqlStr) {
        rabbitTemplate.convertAndSend(exchange, route, sqlStr);
    }


    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put("message", jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }
}
