package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.smile.entity.SmileSchool;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Data
public class SmileSchoolVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    private String schoolId;

    /**
     * 学校名称
     */
    @ApiModelProperty(value = "学校名称")
    private String name;

    /**
     * 地址（省份-地区-详细地址）
     */
    @ApiModelProperty(value = "地址（省份-地区-详细地址）")
    private String address;

    /**
     * 省key
     */
    @ApiModelProperty(value = "省key")
    private String provinceKey;

    /**
     * 省
     */
    @ApiModelProperty(value = "省")
    private String province;

    /**
     * 市key
     */
    @ApiModelProperty(value = "市key")
    private String cityKey;

    /**
     * 市
     */
    @ApiModelProperty(value = "市")
    private String city;

    /**
     * 区key
     */
    @ApiModelProperty(value = "区key")
    private String areaKey;

    /**
     * 区
     */
    @ApiModelProperty(value = "区")
    private String area;


    public SmileSchoolVo copy(SmileSchool smileSchool) {
        //KylinApiCameraDevicesVo kylinApiCameraDevicesVo = KylinApiCameraDevicesVo.getNew();
        //        if (null == source) return null;
        SmileSchoolVo smileSchoolVo = new SmileSchoolVo();
        if (null==smileSchool) return null;
        smileSchoolVo.setId(smileSchool.getId());
        smileSchoolVo.setSchoolId(smileSchool.getId().toString());
        smileSchoolVo.setName(smileSchool.getName());
        smileSchoolVo.setAddress(smileSchool.getAddress());
        smileSchoolVo.setProvinceKey(smileSchool.getProvinceId());
        smileSchoolVo.setProvince(smileSchool.getProvince());
        smileSchoolVo.setCityKey(smileSchool.getCityId());
        smileSchoolVo.setCity(smileSchool.getCity());
        smileSchoolVo.setAreaKey(smileSchool.getAreaId());
        smileSchoolVo.setArea(smileSchool.getArea());
        return smileSchoolVo;
    }
}
