package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * refund返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-31 11:19 上午
 */

@Data
@ApiModel
public class KylinOrderRefundsVo implements Serializable {

    @ApiModelProperty(value = "主键ID")
    private String orderRefundsId;

    @ApiModelProperty(value = "票务订单id")
    private String orderTicketsId;

    @ApiModelProperty(value = "退款编号")
    private String orderRefundCode;

    @ApiModelProperty(value = "批量退款id")
    private String orderRefundBatchesId;

    @ApiModelProperty(value = "退款中心退款编号")
    private String refundCode;

    @ApiModelProperty(value = "成功退款时间")
    private LocalDateTime refundAt;

    @ApiModelProperty(value = "第三方退款编号")
    private String refundId;

    @ApiModelProperty(value = "退款失败原因")
    private String refundError;

    @ApiModelProperty(value = "退款总金额")
    private BigDecimal price;

    @ApiModelProperty(value = "退款状态: 0请求退款 2取消退款 1审核通过 5驳回退款 7等待退款 3正在退款 4完成退款 6退款失败")
    private Integer status;

    @ApiModelProperty(value = "退款差异: 0申请退款返还库存 1自动退款无法取消退款不返还库存")
    private Integer type;

    @ApiModelProperty(value = "申请人id")
    private String applicantId;

    @ApiModelProperty(value = "申请人名称")
    private String applicantName;

    @ApiModelProperty(value = "申请时间")
    private LocalDateTime applicantAt;

    @ApiModelProperty(value = "退款原因")
    private String reason;

    @ApiModelProperty(value = "审核人id")
    private String auditorId;

    @ApiModelProperty(value = "审核人名称")
    private String auditorName;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditorAt;

    @ApiModelProperty(value = "驳回原因")
    private String reject;

    @ApiModelProperty(value = "执行人id")
    private String executorId;

    @ApiModelProperty(value = "执行人名称")
    private String executorName;

    @ApiModelProperty(value = "执行时间")
    private LocalDateTime executorAt;

    @ApiModelProperty(value = "回绝原因")
    private String refuse;

    @ApiModelProperty(value = "票务/快递费/票和快递费")
    private String refundType;

    @ApiModelProperty(value = "订单入场人/搭售款式表 id 多个 ,分割")
    private String orderTicketEntitiesIds;

    @ApiModelProperty(value = "添加时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

}
