package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinPerformancesAdminServiceImpl;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceMemberAuditDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances")
public class KylinPerformancesController extends BaseController {
    private String prefix = "zhengzai/kylin/performances";

    @Autowired
    private KylinPerformancesAdminServiceImpl kylinPerformancesService;

    @RequiresPermissions("kylin:performances:view")
    @GetMapping()
    public String performances() {
        return prefix + "/performances";
    }

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performances:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(PerformanceAdminListParam performanceAdminListParam) {
        startPage();/**/
        PageInfo<PerformanceAdminListDao> result = kylinPerformancesService.getList(performanceAdminListParam);
        return getDataTable(result.getList());
    }

    @RequiresPermissions("kylin:performances:detail")
    @GetMapping(value = "/details/{performancesId}")
    public String performanceDetails(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceMisVo result = null;
        result = kylinPerformancesService.performanceDetails(performancesId);
        mmap.put("kylinPerformanceMisVo", result);
        return prefix + "/details";
    }

    @PostMapping(value = "/audit")
    @RequiresPermissions("kylin:performances:audit")
    @ResponseBody
    public AjaxResult performanceAudit(@RequestParam("performancesId") String performancesId, @RequestParam("status") int status, @RequestParam(value = "rejectTxt", required = false) String rejectTxt) {
        boolean result = kylinPerformancesService.performanceAudit(performancesId, status, rejectTxt);
        return toAjax(result);
    }

    @RequiresPermissions("kylin:performances:change")
    @PostMapping(value = "/isShow")
    @ResponseBody
    public AjaxResult setIsShow(String performancesId, Integer isShow) {
        return toAjax(kylinPerformancesService.setIsShow(performancesId, isShow));
    }

    @RequiresPermissions("kylin:performances:member")
    @GetMapping(value = "/memberInfo/{performancesId}")
    public String memberInfo(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceMemberAuditDao result = kylinPerformancesService.performanceMemberInfo(performancesId);
        mmap.put("performanceMemberAuditDao", result);
        return prefix + "/memberInfo";
    }
}
