package com.liquidnet.client.admin.zhengzai.adam.mapper;

import java.util.List;
import com.liquidnet.client.admin.zhengzai.adam.domain.AdamUser;

/**
 * 用户Mapper接口
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
public interface AdamUserMapper 
{
    /**
     * 查询用户
     * 
     * @param mid 用户ID
     * @return 用户
     */
    public AdamUser selectAdamUserById(Integer mid);

    /**
     * 查询用户列表
     * 
     * @param adamUser 用户
     * @return 用户集合
     */
    public List<AdamUser> selectAdamUserList(AdamUser adamUser);

    /**
     * 新增用户
     * 
     * @param adamUser 用户
     * @return 结果
     */
    public int insertAdamUser(AdamUser adamUser);

    /**
     * 修改用户
     * 
     * @param adamUser 用户
     * @return 结果
     */
    public int updateAdamUser(AdamUser adamUser);

    /**
     * 删除用户
     * 
     * @param mid 用户ID
     * @return 结果
     */
    public int deleteAdamUserById(Integer mid);

    /**
     * 批量删除用户
     * 
     * @param mids 需要删除的数据ID
     * @return 结果
     */
    public int deleteAdamUserByIds(String[] mids);
}
