package com.liquidnet.service.consumer.adam.receiver;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.common.sms.processor.SmsProcessor;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SmsMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamListener;

import javax.annotation.Resource;
import java.util.HashMap;

@Slf4j
public abstract class AbstractSmsRedisReceiver implements StreamListener<String, MapRecord<String, String, String>> {
    @Resource
    SmsProcessor smsProcessor;
    @Autowired
    StringRedisTemplate stringRedisTemplate;


    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        log.debug("CONSUMER SMS[streamKey:{},messageId:{},stream:{},body:{}]",
                this.getRedisStreamKey(), message.getId(), message.getStream(), message.getValue());

        boolean result = this.consumerSmsSendHandler(message.getValue().get("message"));
        log.info("CONSUMER SMS RESULT:{} ==> MESSAGE_ID:{}", result, message.getId());

        try {
            stringRedisTemplate.opsForStream().acknowledge(getRedisStreamGroup(), message);
            stringRedisTemplate.opsForStream().delete(this.getRedisStreamKey(), message.getId());
        } catch (Exception e) {
            log.error("#CONSUMER SMS RESULT:{} ==> DEL_REDIS_QUEUE_MSG_EXCEPTION[MESSAGE_ID:{},MSG:{}]", result, message.getId(), JsonUtils.toJson(message), e);
        } finally {
            try {
                stringRedisTemplate.opsForStream().acknowledge(getRedisStreamGroup(), message);
            } catch (Exception ignored) {
            }
        }
    }

    private boolean consumerSmsSendHandler(String msg) {
        boolean aBoolean = false;
        try {
            SmsMessage smsMessage = JsonUtils.fromJson(msg, SmsMessage.class);
//            aBoolean = smsProcessor.send(smsMessage.getPhone(), smsMessage.getSignName(), smsMessage.getTemplateCode(), smsMessage.getTemplateParam().toString());
            ObjectNode templateParam = smsMessage.getTemplateParam();
            aBoolean = smsProcessor.send(smsMessage.getPhone(), smsMessage.getSignName(), smsMessage.getTemplateCode(), null == templateParam ? "" : templateParam.toString());
        } catch (Exception e) {
            log.error("CONSUMER SMS FAIL ==> {}", e.getMessage(), e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }

    protected abstract String getRedisStreamKey();

    protected abstract String getRedisStreamGroup();
}
