package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 精选商品
 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-04
 */
@Api(tags = "精选商品")
@RestController
@RequestMapping("/selectGoods")
public class GoblinFrontSelectGoodsController extends BaseController {

    private GoblinGoodsMapper goblinGoodsMapper;
    /***
     * @author zhangfuxin
     * @Description:  商品列表
     * @date 2022/1/4 下午2:46
     */
    @GetMapping("goodsList")
    @ApiOperation(value = "商品列表")
    @ResponseBody
    public AjaxResult goodsList(@RequestParam(name = "type", required = false) String type) {
        LambdaQueryWrapper<GoblinGoods> queryWrapper = Wrappers.lambdaQuery(GoblinGoods.class);
        queryWrapper.eq(GoblinGoods::getShelvesStatus,3);
        queryWrapper.eq(GoblinGoods::getDelFlg,0);
        //1、上架时间2、销量3、价格高到低4、价格低到高
        if(!StringUtil.isNotBlank(type)||type.equals("1")){
            queryWrapper.orderByDesc(GoblinGoods::getCreatedAt);
        }else if(type.equals("2")){
            //销量 暂时不考虑
        }else if(type.equals("3")){
            //价格从高到低
            queryWrapper.orderByDesc(GoblinGoods::getPriceGe);
        }else{
            queryWrapper.orderByAsc(GoblinGoods::getPriceGe);
        }
        List<GoblinGoods> list=goblinGoodsMapper.selectList(queryWrapper);
        return AjaxResult.success(list);
    }
    
    /***
     * @author zhangfuxin
     * @Description:精选商品保存
     * @date 2022/1/4 下午2:49
     */
    
    /**
     * @author zhangfuxin
     * @Description:精选商品修改
     * @date 2022/1/4 下午2:49
     */
    
    /**
     * @author zhangfuxin
     * @Description: 精选商品获得
     * @date 2022/1/4 下午2:49
     */



}
