package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinZhengzaiMarketService;
import com.liquidnet.client.admin.zhengzai.goblin.utils.GoblinMongoUtils;
import com.liquidnet.client.admin.zhengzai.goblin.utils.GoblinRedisUtils;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.GoblinZhengzaiStoreDetailsDto;
import com.liquidnet.service.goblin.dto.GoblinZhengzaiStoreListDto;
import com.liquidnet.service.goblin.dto.vo.*;
/*import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiVo;*/
import com.liquidnet.service.goblin.entity.GoblinMarketingZhengzaiRelation;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;
import com.liquidnet.service.goblin.mapper.GoblinMarketingZhengzaiRelationMapper;
import com.liquidnet.service.goblin.mapper.GoblinSelfMarketingMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * 正在下单相关
 */
@Service
public class GoblinZhengzaiMarketServiceImpl implements IGoblinZhengzaiMarketService {

    @Value("${liquidnet.service.adam.url}")
    String goblinUrl;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    GoblinSelfMarketingMapper goblinSelfMarketingMapper;
    @Autowired
    GoblinMarketingZhengzaiRelationMapper goblinMarketingZhengzaiRelationMapper;

    @Override
    public ResponseDto<List<GoblinSelfMarketing>> zhengzaiList(int page, String purchaseName, int status, String st, String et, String ct) {
        LambdaUpdateWrapper<GoblinSelfMarketing> queryMapper = Wrappers.lambdaUpdate(GoblinSelfMarketing.getNew()).eq(GoblinSelfMarketing::getDelFlag, 0);
        switch (status) {
            case 0://未开始
                queryMapper.lt(GoblinSelfMarketing::getStartTime, DateUtil.getNowTime());
                break;
            case 1://进行中
                queryMapper.ge(GoblinSelfMarketing::getStartTime, DateUtil.getNowTime()).le(GoblinSelfMarketing::getEndTime, DateUtil.getNowTime());
                break;
            case 2://已结束
                queryMapper.gt(GoblinSelfMarketing::getEndTime, DateUtil.getNowTime());
                break;
            case 7://停用
                queryMapper.gt(GoblinSelfMarketing::getStatus, GoblinStatusConst.MarketingStatus.STORE_PURCHASE_STATUS_STOP);
                break;
        }

        if (st != null && et != null) {
            queryMapper.ge(GoblinSelfMarketing::getStartTime, st).le(GoblinSelfMarketing::getEndTime, et);
        }
        if (ct != null) {
            queryMapper.eq(GoblinSelfMarketing::getCreatedAt, ct);
        }
        return ResponseDto.success(goblinSelfMarketingMapper.selectList(queryMapper));
    }

    @Override
    public ResponseDto<Boolean> zhengzaiStatus(String marketId, int status) {
        GoblinSelfMarketing selfMarketing = GoblinSelfMarketing.getNew();
        if (status == -1) {
            selfMarketing.setStatus(0);
            selfMarketing.setDelFlag(1);
            selfMarketing.setUpdatedAt(LocalDateTime.now());
            //mysql
            goblinSelfMarketingMapper.update(selfMarketing, Wrappers.lambdaUpdate(GoblinSelfMarketing.getNew()).eq(GoblinSelfMarketing::getSelfMarketId, marketId));
            //mongo
            goblinMongoUtils.delSelfMarket(marketId);
            //redis
            goblinRedisUtils.delSelfMarket(marketId);
            goblinRedisUtils.delZhengzaiList(marketId);
        } else {
            selfMarketing.setStatus(status);
            selfMarketing.setUpdatedAt(LocalDateTime.now());
            //mysql
            goblinSelfMarketingMapper.update(selfMarketing, Wrappers.lambdaUpdate(GoblinSelfMarketing.getNew()).eq(GoblinSelfMarketing::getSelfMarketId, marketId));
            //mongo
            GoblinSelfMarketingVo vo = GoblinSelfMarketingVo.getNew();
            BeanUtils.copyProperties(selfMarketing, vo);
            GoblinSelfMarketingVo changeVo = goblinMongoUtils.updateSelfMarket(marketId, vo);
            //redis
            goblinRedisUtils.setSelfMarket(marketId, changeVo);
            goblinRedisUtils.changeZhengzaiList(changeVo);
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> zhengzaiInsert(String purchaseName, String st, String et) {
        GoblinSelfMarketing selfMarketing = GoblinSelfMarketing.getNew();
        String SelfMarketId = IDGenerator.nextTimeId2();
        selfMarketing.setSelfMarketId(SelfMarketId);
        selfMarketing.setName(purchaseName);
        selfMarketing.setType(GoblinStatusConst.MarketingStatus.SELF_TYPE_ZHENGZAI.getValue());
        selfMarketing.setStartTime(LocalDateTime.parse(st, DTF_YMD_HMS));
        selfMarketing.setEndTime(LocalDateTime.parse(et, DTF_YMD_HMS));
        selfMarketing.setCreatedAt(LocalDateTime.now());
        //mysql
        goblinSelfMarketingMapper.insert(selfMarketing);
        //mongo
        GoblinSelfMarketingVo vo = GoblinSelfMarketingVo.getNew();
        BeanUtils.copyProperties(selfMarketing, vo);
        vo.setStartTime(st);
        vo.setEndTime(et);
        vo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(selfMarketing.getCreatedAt()));
        goblinMongoUtils.insertSelfMarket(vo);
        //redis
        goblinRedisUtils.setSelfMarket(SelfMarketId, vo);
        goblinRedisUtils.addZhengzaiList(vo);
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> zhengzaiUpdate(String marketId, String purchaseName, String st, String et) {
        GoblinSelfMarketing selfMarketing = GoblinSelfMarketing.getNew();
        selfMarketing.setName(purchaseName);
        selfMarketing.setType(GoblinStatusConst.MarketingStatus.SELF_TYPE_ZHENGZAI.getValue());
        selfMarketing.setStartTime(LocalDateTime.parse(st, DTF_YMD_HMS));
        selfMarketing.setEndTime(LocalDateTime.parse(et, DTF_YMD_HMS));
        selfMarketing.setUpdatedAt(LocalDateTime.now());
        //mysql
        goblinSelfMarketingMapper.update(selfMarketing, Wrappers.lambdaUpdate(GoblinSelfMarketing.getNew()).eq(GoblinSelfMarketing::getSelfMarketId, marketId));
        //mongo
        GoblinSelfMarketingVo vo = GoblinSelfMarketingVo.getNew();
        BeanUtils.copyProperties(selfMarketing, vo);
        vo.setName(purchaseName);
        vo.setStartTime(st);
        vo.setEndTime(et);
        GoblinSelfMarketingVo changeVo = goblinMongoUtils.updateSelfMarket(marketId, vo);
        //redis
        goblinRedisUtils.setSelfMarket(marketId, vo);
        goblinRedisUtils.changeZhengzaiList(changeVo);
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<GoblinSelfMarketingVo> zhengzaiDetails(String marketId) {
        GoblinSelfMarketing bean = goblinSelfMarketingMapper.selectOne(Wrappers.lambdaUpdate(GoblinSelfMarketing.getNew()).eq(GoblinSelfMarketing::getSelfMarketId, marketId));
        GoblinSelfMarketingVo vo = GoblinSelfMarketingVo.getNew();
        BeanUtils.copyProperties(bean, vo);
        vo.setStartTime(DateUtil.Formatter.yyyyMMddHHmmss.format(bean.getStartTime()));
        vo.setEndTime(DateUtil.Formatter.yyyyMMddHHmmss.format(bean.getEndTime()));
        vo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(bean.getCreatedAt()));
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<List<GoblinZhengzaiStoreListVo>> zhengzaiStoreList(String marketId) {
        List<GoblinZhengzaiStoreListDto> dtoList = goblinSelfMarketingMapper.getZhengzaiStoreList(marketId);
        List<GoblinZhengzaiStoreListVo> voList = new ArrayList<>();
        for (GoblinZhengzaiStoreListDto item : dtoList) {
            GoblinZhengzaiStoreListVo vo = GoblinZhengzaiStoreListVo.getNew();
            vo.setStoreId(item.getStoreId());
            vo.setStoreName(item.getStoreName());
            vo.setSpuCount(item.getSpuCount());
            vo.setSkuCount(item.getSkuCount());
        }
        return ResponseDto.success(voList);
    }

    @Override
    public ResponseDto<Boolean> zhengzaiStore(String marketId, String storeId, String showTime) {
        GoblinMarketingZhengzaiRelation entity = GoblinMarketingZhengzaiRelation.getNew();
        entity.setSelfMarketId(marketId);
        entity.setStoreId(storeId);
        entity.setShowTime(LocalDateTime.parse(showTime, DTF_YMD_HMS));
        //mysql
        goblinMarketingZhengzaiRelationMapper.insert(entity);
        //mongo
        GoblinMarketingZhengzaiRelationVo vo = GoblinMarketingZhengzaiRelationVo.getNew();
        BeanUtils.copyProperties(entity, vo);
        vo.setShowTime(showTime);
        vo.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(entity.getCreatedAt()));
        goblinMongoUtils.insertZhengzaiRelation(vo);
        //redis
        goblinRedisUtils.setZhengzaiRelation(marketId, vo);
        goblinRedisUtils.addStoreSelfRelation(marketId, storeId);
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> zhengzaiStore(String marketId, String storeId, String showTime, Integer delTag) {
        if (delTag == 0) {
            GoblinMarketingZhengzaiRelation entity = GoblinMarketingZhengzaiRelation.getNew();
            entity.setShowTime(LocalDateTime.parse(showTime, DTF_YMD_HMS));
            entity.setUpdatedAt(LocalDateTime.now());
            //mysql
            goblinMarketingZhengzaiRelationMapper.update(entity, Wrappers.lambdaUpdate(GoblinMarketingZhengzaiRelation.getNew()).eq(GoblinMarketingZhengzaiRelation::getSelfMarketId, marketId).eq(GoblinMarketingZhengzaiRelation::getStoreId, storeId));
            //mongo
            GoblinMarketingZhengzaiRelationVo vo = GoblinMarketingZhengzaiRelationVo.getNew();
            BeanUtils.copyProperties(entity, vo);
            vo.setShowTime(showTime);
            goblinMongoUtils.updateZhengzaiRelation(marketId, storeId, vo);
            //redis
            goblinRedisUtils.setZhengzaiRelation(marketId, vo);
            goblinRedisUtils.addStoreSelfRelation(marketId, storeId);
        } else if (delTag == 1) {
            GoblinMarketingZhengzaiRelation entity = GoblinMarketingZhengzaiRelation.getNew();
            entity.setDelTag(1);
            entity.setUpdatedAt(LocalDateTime.now());
            //mysql
            goblinMarketingZhengzaiRelationMapper.update(entity, Wrappers.lambdaUpdate(GoblinMarketingZhengzaiRelation.getNew()).eq(GoblinMarketingZhengzaiRelation::getSelfMarketId, marketId).eq(GoblinMarketingZhengzaiRelation::getStoreId, storeId));
            //mongo
            goblinMongoUtils.delZhengzaiRelation(marketId, storeId);
            //redis
            goblinRedisUtils.delZhengzaiRelation(marketId, storeId);
            goblinRedisUtils.delStoreSelfRelation(marketId, storeId);
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<List<GoblinMarketSpuListVo>> zhengzaiSpuList(String marketId, String storeId,int page) {
        MultiValueMap<String, String> params = new LinkedMultiValueMap();
        params.add("selfMarketId", marketId);
        params.add("storeId", storeId);
        params.add("page", page+"");
        String returnData = HttpUtil.post(goblinUrl + "/goblin/inner/config/del", params, null);
        ResponseDto<List<GoblinMarketSpuListVo>> rsp = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<List<GoblinMarketSpuListVo>>>() {
        });
        return rsp;
    }

    @Override
    public ResponseDto<List<GoblinSelfZhengzaiSkuVo>> zhengzaiSkuList(String marketId, String storeId, String spuId) {
        MultiValueMap<String, String> params = new LinkedMultiValueMap();
        params.add("selfMarketId", marketId);
        params.add("storeId", storeId);
        params.add("spuId", spuId);
        String returnData = HttpUtil.post(goblinUrl + "/goblin/inner/config/del", params, null);
        ResponseDto<List<GoblinSelfZhengzaiSkuVo>> rsp = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<List<GoblinSelfZhengzaiSkuVo>>>() {
        });
        return rsp;
    }

    @Override
    public ResponseDto<Boolean> zhengzaiSkuDel(String marketId, String storeId, String spuId) {
        //调用goblin商铺配置商铺接口
        MultiValueMap<String, String> params = new LinkedMultiValueMap();
        params.add("selfMarketId", marketId);
        params.add("storeId", storeId);
        params.add("spuId", spuId);
        String returnData = HttpUtil.post(goblinUrl + "/goblin/inner/config/del", params, null);
        ResponseDto<Boolean> rsp = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<Boolean>>() {
        });
        return rsp;
    }
}
