package com.liquidnet.service.stone.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.vo.StoneLogsListVo;

import java.util.List;

/**
 * <p>
 * 积分日志表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
public interface IStoneScoreLogsService {

    /**
     * 减少积分
     *
     * @param uid     用户ID
     * @param score   变更积分 正数
     * @param taskId  [2111-admin访问]
     * @param content 变更原因
     * @return
     */
    String deScore(String uid, Integer score, Integer taskId, String content);

    /**
     * 增加积分
     *
     * @param uid     用户ID
     * @param score   变更积分 正数
     * @param taskId  [2111-admin访问]
     * @param content 变更原因
     * @return
     */
    String inScore(String uid, Integer score, Integer taskId, String content);

    /**
     * 做任务
     *
     * @param taskId [
     *               taskId  0  每日任务：签到
     *               taskId  1  每日任务：购买演出
     *               taskId  2  每日任务：购买商品
     *               taskId  3  每日任务：划卡
     *               taskId  4  一次性任务：关注公众号
     *               taskId  5  一次性任务：完善信息
     *               taskId  6  一次性任务：完善头像
     *               taskId  7  一次性任务：打开消息推送
     *               taskId  8  一次性任务：体验在场
     *               ]
     * @return
     */
    ResponseDto<String> task(Integer taskId);

    /**
     * 积分详情
     * @param page
     * @return
     */
    PageInfo<List<StoneLogsListVo>> logList(Integer page);
}
