package com.liquidnet.service.platform.service.impl.partner;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildPerformanceDao;
import com.liquidnet.service.kylin.dto.param.CheckPerformanceRelationParam;
import com.liquidnet.service.kylin.dto.param.CheckUserParam;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinCheckUserPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinCheckUserPerformances;
import com.liquidnet.service.kylin.mapper.KylinCheckUserPerformancesMapper;
import com.liquidnet.service.kylin.service.partner.IKylinCheckUserPerformancesPartnerService;
import com.liquidnet.service.platform.utils.DataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 验票用户可看演出表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Service
public class KylinCheckUserPerformancesPartnerServiceImpl extends ServiceImpl<KylinCheckUserPerformancesMapper, KylinCheckUserPerformances> implements IKylinCheckUserPerformancesPartnerService {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private KylinCheckUserPerformancesMapper checkUserPerformancesMapper;

    @Override
    public ResponseDto<PageInfo<ChildPerformanceDao>> childPerformanceList(String merchantId, String checkUserId, int page, int size, String name) {
        PageInfo<ChildPerformanceDao> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<ChildPerformanceDao> data = checkUserPerformancesMapper.childPerformanceList(merchantId, checkUserId, name);
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<PageInfo<ChildPerformanceDao>> unChildPerformanceList(String merchantId, String checkUserId, int page, int size, String name) {
        PageInfo<ChildPerformanceDao> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<ChildPerformanceDao> data = checkUserPerformancesMapper.unChildPerformanceList(merchantId, checkUserId, name);
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<String> setPerformance(CheckUserParam param) {
        try {
            for (CheckPerformanceRelationParam item : param.getCheckPerformanceRelationParamList()) {
                if (null == item.getCanDownTime()) {
                    return ResponseDto.failure(ErrorMapping.get(20101));
                }
                KylinCheckUserPerformances checkUserPerformances = new KylinCheckUserPerformances();
                checkUserPerformances.setCheckUserId(param.getCheckUserId());
                checkUserPerformances.setCanDownTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(item.getCanDownTime()));
                checkUserPerformances.setPerformanceId(item.getPerformanceId());
                checkUserPerformances.setCheckUserPerformanceId(IDGenerator.nextSnowId());
                checkUserPerformances.setCreatedAt(LocalDateTime.now());
                checkUserPerformances.setStatus(1);
                checkUserPerformancesMapper.insert(checkUserPerformances);
            }
            mongoTemplate.remove(Query.query(Criteria.where("checkUserId").is(param.getCheckUserId())), KylinCheckUserPerformanceVo.class, KylinCheckUserPerformanceVo.class.getSimpleName());

            KylinCheckUserPerformanceVo userPerformanceVo = new KylinCheckUserPerformanceVo();
            List<CheckPerformanceRelationParam> performanceRelationParamsList = new ArrayList<>();
            List<KylinCheckUserPerformances> data = checkUserPerformancesMapper.selectList(new UpdateWrapper<KylinCheckUserPerformances>().eq("check_user_id", param.getCheckUserId()));
            for (KylinCheckUserPerformances item : data) {
                CheckPerformanceRelationParam performanceRelationParam = new CheckPerformanceRelationParam();
                performanceRelationParam.setCanDownTime(item.getCanDownTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                performanceRelationParam.setPerformanceId(item.getPerformanceId());
                performanceRelationParamsList.add(performanceRelationParam);
            }
            userPerformanceVo.setCheckUserId(param.getCheckUserId());
            userPerformanceVo.setRelationParams(performanceRelationParamsList);

            mongoTemplate.insert(userPerformanceVo, KylinCheckUserPerformanceVo.class.getSimpleName());
            dataUtils.delCheckUserRelationRedis(param.getCheckUserId());
            return ResponseDto.success("添加成功");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure(ErrorMapping.get(20101));
        }
    }

    @Override
    public ResponseDto<String> delPerformance(List<String> performanceIds, String checkUserId) {
        try {
            for (String performanceId : performanceIds) {
                checkUserPerformancesMapper.delete(new UpdateWrapper<KylinCheckUserPerformances>().eq("check_user_id", checkUserId).eq("performance_id", performanceId));
            }
            mongoTemplate.remove(Query.query(Criteria.where("checkUserId").is(checkUserId)), KylinCheckUserPerformanceVo.class, KylinCheckUserPerformanceVo.class.getSimpleName());

            KylinCheckUserPerformanceVo userPerformanceVo = new KylinCheckUserPerformanceVo();
            List<CheckPerformanceRelationParam> performanceRelationParamsList = new ArrayList<>();
            List<KylinCheckUserPerformances> data = checkUserPerformancesMapper.selectList(new UpdateWrapper<KylinCheckUserPerformances>().eq("check_user_id", checkUserId));
            for (KylinCheckUserPerformances item : data) {
                CheckPerformanceRelationParam performanceRelationParam = new CheckPerformanceRelationParam();
                performanceRelationParam.setCanDownTime(item.getCanDownTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                performanceRelationParam.setPerformanceId(item.getPerformanceId());
                performanceRelationParamsList.add(performanceRelationParam);
            }
            userPerformanceVo.setCheckUserId(checkUserId);
            userPerformanceVo.setRelationParams(performanceRelationParamsList);
            mongoTemplate.insert(userPerformanceVo, KylinCheckUserPerformanceVo.class.getSimpleName());
            dataUtils.delCheckUserRelationRedis(checkUserId);
            return ResponseDto.success("删除成功");
        } catch (Exception e) {
            return ResponseDto.failure(ErrorMapping.get(20102));
        }
    }
}
