package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamLoginInfoVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamLoginClient {

    @PostMapping(value =  "login/sms")
    ResponseDto<AdamLoginInfoVo> loginBySms(@RequestParam String mobile, @RequestParam String code);

    @PostMapping(value = {"login/mobile"})
    ResponseDto<AdamLoginInfoVo> loginByMobile(@RequestParam String accessToken);

    @PostMapping(value = {"login/tpa"})
    ResponseDto<AdamLoginInfoVo> loginByTpa(@RequestBody AdamThirdPartParam parameter);
}
