package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 店铺设置
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 参数名称
     */
    private String configName;

    /**
     * 参数键名
     */
    private String configKey;

    /**
     * 参数键值
     */
    private String configVal;

    /**
     * 参数描述
     */
    private String configDesc;

    /**
     * 保留字段
     */
    private String configType;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String comment;


}
