package com.liquidnet.service.galaxy.constant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyErrorCodeEnum
 * @Package com.liquidnet.service.galaxy.constant
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/8 11:25
 */
public enum GalaxyErrorEnum {
    SERIES_CLAIM_ERROR("NFT0010001","NFT系列声明失败"),
    SERIES_CLAIM_ERROR_FIVE_TIMES("NFT0010002","NFT系列声明失败,任务查询超过5次"),
    PUBLISH_FAIL("NFT0010003","NFT发行失败,未获取nft"),
    PUBLISH_BUY_FAIL("NFT0010004","NFT发行购买失败,未发起购买"),
    PUBLISH_FAIL_ALREADY_EXIST("NFT0010005","NFT发行失败,该订单已经发行过指定nft！"),
    ROUTER_NOT_EXIST("NFT0010006","路由类型不存在"),
    SERIES_NOT_EXIST("NFT0010007","没有查询到该sku对应系列声明"),
    SERIES_CLAIM_PROCESSING("NFT0010008","系列声明正在处理中,不允许重复声明！"),
    SERIES_CLAIM_SUCCESSED("NFT0010009","系列已声明成功，不允许重复声明！"),
    SERIES_CLAIM_NOT_EXIST("NFT0010010","系列声明初始化信息不存在，请检查是否已上传对应素材！");

    private String code;
    private String message;
    GalaxyErrorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }
    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
