package com.liquidnet.service.galaxy.dto.vo.mongo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 用户注册信息
 * @class: GalaxyUserInfoBo
 * @Package com.liquidnet.service.galaxy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 14:34
 */
@Data
public class GalaxyUserInfoVo implements Serializable,Cloneable{
    private String userId;
    /**
     * 用户姓名
     */
    private String userName;
    /**
     * 移动手机号
     */
    private String mobile;
    /**
     * 证件类型
     */
    private String idCardType;
    /**
     * 证件号码
     */
    private String idCard;
    /**
     * 助记词
     */
    private String mnemonic;
    /**
     * 助记词绑定索引
     */
    private String index;
    /**
     * 用户唯一ID
     */
    private String userIdentification;
    /**
     * 用户公钥
     */
    private String userPubKey;
    /**
     * 用户私钥
     */
    private String userPriKey;
    /**
     * 路由类型
     */
    private String routerType;
    /**
     * 用户平台地址
     */
    private String blockChainAddress;
    /**
     * 创建时间
     */
    private String createdAt;
    /**
     * 更新时间
     */
    private String updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyUserInfoVo obj = new GalaxyUserInfoVo();

    public static GalaxyUserInfoVo getNew() {
        try {
            return (GalaxyUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyUserInfoVo();
        }
    }
}

