package com.liquidnet.service.galaxy;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.Nft022UploadSecretReqDto;
import com.liquidnet.common.third.zxlnft.dto.Nft022UploadSecretRespDto;
import com.liquidnet.common.third.zxlnft.dto.ZxlnftResponseDto;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.galaxy.router.strategy.biz.GalaxyCommonBiz;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.nio.charset.StandardCharsets;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 13:49
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxlWalletSdkUtil {
    private static String platFormPubKey1 = "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE+h73KDgGzZznkP02tXTc0DU3mfXp\nvr7KWAlB63p8J2SU9FtusK5ApcbjoqgPunIkpChvRHQuVKyQpZtBDza3lQ==\n-----END PUBLIC KEY-----\n";
    private static String zhouhuanPubKey1 = "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAERAYCoqlcb1/C+b085HO4RWbIFx/n\nw6zkU3tvIYhBi1Xjj7GMdE/dR6D2fCQGWHqdYwQUb6/kS67Yjx47prxREg==\n-----END PUBLIC KEY-----\n";
    private static String zhouhuanPriKey1 = "-----BEGIN PRIVATE KEY-----\nMIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgjSDapAU4gujWk9mM\nCE1tOokocdKrHMkfvZ0vfaWM+MOgCgYIKoEcz1UBgi2hRANCAAREBgKiqVxvX8L5\nvTzkc7hFZsgXH+fDrORTe28hiEGLVeOPsYx0T91HoPZ8JAZYep1jBBRvr+RLrtiP\nHjumvFES\n-----END PRIVATE KEY-----\n";
    private static String zhouhuanPubKey2 = "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAELZtnP30dbtdFrvherJxfpPEQP+q3\nRyrtECAuEwZg3o8/RLJva0O6unNLHGavkwd77l5UgvX4cPNoX/OV6n/3xQ==\n-----END PUBLIC KEY-----\n";
    private static String zhouhuanPriKey2 = "-----BEGIN PRIVATE KEY-----\nMIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgNBYWsObyiuXLIZZZ\nPa0P/aNSrlf3//TLkdhZsDroRNugCgYIKoEcz1UBgi2hRANCAAQtm2c/fR1u10Wu\n+F6snF+k8RA/6rdHKu0QIC4TBmDejz9Esm9rQ7q6c0scZq+TB3vuXlSC9fhw82hf\n85Xqf/fF\n-----END PRIVATE KEY-----\n";
    private static String zhouhuanAddress1 = "zxf8dcce2b5374610631735ad4d606372ff199d89e";
    private static String zhouhuanAddress2 = "zx26ff9db9cf1e981e3028b7e133d54b28eb859f97";


    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private GalaxyCommonBiz galaxyCommonBiz;

    /**
     * 1、生成助记词
     */
    @Test
    public void createMnemonic(){
        CreateMnemonicReq req = CreateMnemonicReq.getNew();
        zxlWalletSdkUtil.createMnemonic(req);
    }

    /**
     * 2、API签名
     */
    @Test
    public void generateApiSign(){
        GenerateApiSignReq req = GenerateApiSignReq.getNew();
        req.setAppId("");
        req.setAppKey("");
        zxlWalletSdkUtil.generateApiSign(req);
    }

    /**
     * 3、文件上传至COS
     */
    @Test
    public void uploadToCos(){
//        String filePath = "/Users/anjiabin/Downloads/zxl_image_test_002.jpeg";
//        String filePath = "/Users/anjiabin/Downloads/zxl_image_series_test_001.jpeg";
//        String filePath = "/Users/anjiabin/Downloads/zxl_image_test_001.jpg";
//        String filePath = "https://img.zhengzai.tv/other/2022/03/09/1f88d2bc6fea40e19430227326410cb3.jpg";
        String filePath = "/Users/anjiabin/Downloads/春季花卉TEST001.mp4";
        String seriesName = "NOW_ZXL_NFT_PIC001_skuId001_test";
//        String fileName = "/"+ seriesName + "/" + DateUtil.getNowTime()+"/"+ IDGenerator.getZxlNftImageCosCode() +".jpg";
//        String fileName = DateUtil.getNowTime(DateUtil.DATE_SMALL_STR)+"/"+ IDGenerator.getZxlNftImageCosCode() +".jpg";
        String fileName = DateUtil.getNowTime(DateUtil.DATE_SMALL_STR)+"/"+ IDGenerator.getZxlNftImageCosCode() +".mp4";
        System.out.println("fileName====="+fileName);
        //调用生成素材上传临时密钥接口
        Nft022UploadSecretReqDto nft022ReqDto = Nft022UploadSecretReqDto.getNew();
        nft022ReqDto.setSeriesName(seriesName);
        nft022ReqDto.setTimestamp(DateUtil.getNowSeconds().toString());
        nft022ReqDto.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());

        //系列为空
        String userData = nft022ReqDto.getTimestamp();
        //系列不为空
        if(StringUtil.isNotEmpty(nft022ReqDto.getSeriesName())){
            userData = nft022ReqDto.getTimestamp() + "_" + nft022ReqDto.getSeriesName();
        }

        nft022ReqDto.setUserSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),userData));

        ZxlnftResponseDto<Nft022UploadSecretRespDto> nft022RespDto = zxlnftSdkUtil.nft022UploadSecret(nft022ReqDto);

        if(nft022RespDto.isSuccess()){
            UploadToCosReq req = UploadToCosReq.getNew();
            req.setCosPath(nft022RespDto.getData().getUploadAddress().concat(fileName));
            req.setTempSecretId(nft022RespDto.getData().getTempSecretId());
            req.setTempSecretKey(nft022RespDto.getData().getTempSecretKey());
            req.setSessionToken(nft022RespDto.getData().getSessionToken());
            req.setFilePath(filePath);
            UploadToCosResp resp = zxlWalletSdkUtil.uploadToCos(req);
            System.out.println("返回结果："+resp.toString());
        }
    }

    /**
     * 4、文件上传至COS(form-data文件提交)
     */
    @Test
    public void uploadFileToCos(){
        UploadFileToCosReq req = UploadFileToCosReq.getNew();
//        req.setCosPath("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/zxl_image_test_001");
//        req.setTempSecretId("AKIDhVGgR7gKaVE5qUIpSPD9k6pcmUj7fobmEspHDlCjC27Te6Dmputh-fI87qvL2EDT");
//        req.setTempSecretKey("xuNqn+FfVjm0Ug0je9k1Mn5MQHKlWKs18uU03KIMAH0=");
//        req.setSessionToken("fwJfhxx5ILXFYNItgiQid1bBiTrofX5af128eb2fa96eef4d9841c98756853142d0X-nPNtZgA0AEIwJ-MAJigzB3IZOgDjLorykjfoxAHusyQ_HeAhvHSlORtPol_iqqJVolGP78H5byiZKhKxATIZiJzrTCQysR02tR1vJPkJp03VH70sSzTJ3WcyTPpBs_NCuXkYvLZaDbRKmE8Xln4uqDJDSthNNaQKBJBYJNnxmVpCRCIeIyqOvQrSKXRGkvkjQ79Enlq7iUeKSqXrpKEBliAq9hgMrXPRHapqihseRl-WerjB4BgQ261mmOuZD6oHg37EPy_JrHAJxHh9dJlFlqz3CxUL-We36RcQeDpLvL1KuzZUBBmjSb0SYMvnun7SOEDdDMF0-1ApATsyQ-bTgDiCHAoo5Xqf9CcFKop-rUeQEDKSV17raeRRcN6ZcBQ-BJ5s4R4bqRm3y1nUwePNKD1Hi2__-nPUKuI5o535wkQcqMeDhQ40Fg3jCcPPRJ-9_Egp3yTEraTkfihKDAXTZnhiQdxaDInlP1JFJKZwY5b0hinlW6yaxnaUzYyXqTVY2tEufNOu5Sn4fGOTZmyqJJ0oDsCJiby-92vKqIS9fHIzemEXfuCULNdonmEThspBA7tUAUr-fY1KCjTMolhG0XvsJ-hNVzwNbpLMLd87TwajlyqJisnn5-sR-wuj9Hx9Inoe5kTRX-0F0NeP9vcfpYZns5No5jrBM74HMgOOSplXZ3yuML42LxTtw9SWcsxqFQJpohTyijpbrwdkKlwc0qGyUIPy7WQ7Jltb7iE");
//        req.setName("/Users/anjiabin/Downloads/zxl_image_test_001.jpg");
//        req.setFile("/Users/anjiabin/Downloads/zxl_image_test_001.jpg");
        zxlWalletSdkUtil.uploadFileToCos(req);
    }

    /**
     * 5、派生生成子公私钥对
     */
    @Test
    public void deriveKeyPair(){
        DeriveKeyPairReq req = DeriveKeyPairReq.getNew();
//        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());

        //stuff name goat health siren dumb gorilla antique board tenant buffalo present
        req.setMnemonic("stuff name goat health siren dumb gorilla antique board tenant buffalo present");
        req.setIndex(1l);

//        req.setMnemonic("region");
//        req.setIndex(0l);
//
//        req.setMnemonic("use");
//        req.setIndex(2l);

        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlWalletSdkUtil.deriveKeyPair(req);
    }

    /**
     * 6、SDK签名
     */
    @Test
    public void signByPriKey(){
        SignByPriKeyReq req = SignByPriKeyReq.getNew();
//        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setData("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlWalletSdkUtil.signByPriKey(req);
    }

    /**
     * 7、私钥生成对应公钥
     */
    @Test
    public void priKey2PubKey(){
        PriKey2PubKeyReq req = PriKey2PubKeyReq.getNew();
        req.setPri(zhouhuanPriKey1);
        zxlWalletSdkUtil.priKey2PubKey(req);
    }

    /**
     * 8、公钥生成对应地址
     */
    @Test
    public void pubKey2Address(){
        PubKey2AddressReq req = PubKey2AddressReq.getNew();
        req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
//        req.setPubKey(zhouhuanPubKey1);
        zxlWalletSdkUtil.pubKey2Address(req);

    }

    /**
     * 9、私钥生成对应地址
     */
    @Test
    public void priKey2Address(){
        PriKey2AddressReq req = PriKey2AddressReq.getNew();
        req.setPriKey(zhouhuanPriKey1);
        zxlWalletSdkUtil.priKey2Address(req);
    }

    /**
     * 10、SDK验签
     */
    @Test
    public void verifyByPubKey(){
        VerifyByPubKeyReq req = VerifyByPubKeyReq.getNew();
        req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        req.setData("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        req.setSignedData("3045022100f062e29953951317c6577ba5d7641d3f19c38930dbb8a93e7b9be699f3f208450220723b87ec6c1f4efd3f70b39b586b74bf52576c6ca8a8bb3d9ddd21255651dff8");
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlWalletSdkUtil.verifyByPubKey(req);
    }

    /**
     * 11、SDK-SM3哈希 这个是44位，暂时不用
     */
    @Test
    public void sM3Hash(){
        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
        cosUrl = "https://nft-user-1255940152.file.myqcloud.com/nft/5867f50e40075319f8bc0bdca59967414d1d9046a4d3c1aaf9bdd8199bb46e4a/0d2d845b56feee933c705786add60b5f12f2909ffcfa7a6b23e58d47a83918cf/%E7%82%AB%E8%BF%882022%E5%AD%A3%E8%8A%82%E7%8F%8D%E8%97%8F%E7%89%88%E6%96%B0%E4%B8%8A%E5%B8%82%E7%B3%BB%E5%88%97/nft_img_20220308_126193.png";
        SM3HashReq req = SM3HashReq.getNew();
        req.setData(cosUrl.getBytes(StandardCharsets.UTF_8));
        SM3HashResp resp = zxlWalletSdkUtil.sM3Hash(req);
        System.out.println(resp.toString());
    }

    /**
     * 12、SDK-SM3哈希EnCode 这个是64位
     */
    @Test
    public void sM3HashEncode(){
        String cosUrl = "https://nft-user-1255940152.file.myqcloud.com/nft/5867f50e40075319f8bc0bdca59967414d1d9046a4d3c1aaf9bdd8199bb46e4a/0d2d845b56feee933c705786add60b5f12f2909ffcfa7a6b23e58d47a83918cf/%E7%82%AB%E8%BF%882022%E5%AD%A3%E8%8A%82%E7%8F%8D%E8%97%8F%E7%89%88%E6%96%B0%E4%B8%8A%E5%B8%82%E7%B3%BB%E5%88%97/nft_img_20220308_126193.png";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241628485194860245.jpg";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef//2022-02-24/ZXLNFTIMAGE202202241704292368452405.jpg";
        cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
        SM3HashEncodeReq req = SM3HashEncodeReq.getNew();
        req.setData(cosUrl.getBytes(StandardCharsets.UTF_8));
        SM3HashEncodeResp resp = zxlWalletSdkUtil.sM3HashEncode(req);
        System.out.println(resp.toString());
    }

    @Test
    public void sM3HashEncode2(){
        String cosUrl = "https://nft-user-1255940152.file.myqcloud.com/nft/5867f50e40075319f8bc0bdca59967414d1d9046a4d3c1aaf9bdd8199bb46e4a/0d2d845b56feee933c705786add60b5f12f2909ffcfa7a6b23e58d47a83918cf/%E7%82%AB%E8%BF%882022%E5%AD%A3%E8%8A%82%E7%8F%8D%E8%97%8F%E7%89%88%E6%96%B0%E4%B8%8A%E5%B8%82%E7%B3%BB%E5%88%97/nft_img_20220308_126193.png";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241628485194860245.jpg";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef//2022-02-24/ZXLNFTIMAGE202202241704292368452405.jpg";
        cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
        cosUrl = "https://nft-user-1255940152.file.myqcloud.com/nft/5867f50e40075319f8bc0bdca59967414d1d9046a4d3c1aaf9bdd8199bb46e4a/0d2d845b56feee933c705786add60b5f12f2909ffcfa7a6b23e58d47a83918cf/%E7%82%AB%E8%BF%882022%E5%AD%A3%E8%8A%82%E7%8F%8D%E8%97%8F%E7%89%88%E6%96%B0%E4%B8%8A%E5%B8%82%E7%B3%BB%E5%88%97/nft_img_20220308_124595.png";
        SM3HashEncodeReq req = SM3HashEncodeReq.getNew();
        byte[] fileByteArray = zxlnftBiz.getNftFileByteArray(cosUrl);
        req.setData(fileByteArray);
        SM3HashEncodeResp resp = zxlWalletSdkUtil.sM3HashEncode(req);
        System.out.println(resp.toString());
        //eb383d5c4e5a81da3581f275bb8d8dc01910ac2f59e07e48c8e791bf124f59ca
        //eb383d5c4e5a81da3581f275bb8d8dc01910ac2f59e07e48c8e791bf124f59ca
    }
}
