package com.liquidnet.service.adam.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberPriceBuildParam", description = "编辑价格入参")
@Data
public class AdamMemberPriceBuildParam implements Serializable {
    private static final long serialVersionUID = -7331274160877946420L;
    @ApiModelProperty(required = true, value = "会员类型ID")
    @NotBlank(message = "会员类型ID不能为空")
    private String memberId;
    @ApiModelProperty(required = false, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(required = true, value = "原价")
    @DecimalMin(value = "0.01", message = "原价不能小于0.01")
    private BigDecimal price;
    @ApiModelProperty(required = true, value = "折扣价")
    @DecimalMin(value = "0.01", message = "折扣价不能小于0.01")
    private BigDecimal priceFixed;
    @ApiModelProperty(required = true, value = "特价:首次、首年优惠价")
    @DecimalMin(value = "0.01", message = "首年优惠价不能小于0.01")
    private BigDecimal priceSpecial;
    @ApiModelProperty(required = true, value = "有效天数")
    @Min(value = 1, message = "有效天数不得小于1")
    private Integer days;

    @ApiModelProperty(required = false, value = "双倍积分[1-关闭,2-开启]")
    private BigDecimal integralRate;
}
