----                上线需要注意事项            ----
----    1.redis用sweet
----    2.消费用sweet消费
----    3.config、order、smile、consumer-sweet、需要上线
----    4.order需要上线 修改了数据库 未修改vo 纪录代理是否黑名单 代理票提

----                添加代理字段              ----
    alter table kylin_order_ticket_relations
        add agent_status int default 1 comment '代理状态[1-开启|2-关闭]';
    alter table kylin_order_ticket_relations
        add agent_distributions decimal (8,3) default 0 comment '票提';
    alter table kylin_order_ticket_relations
        add agent_id_master varchar (64) default "" comment '总代id';
    alter table kylin_order_ticket_relations
        add agent_distributions_master decimal (8,3) default 0 comment '总代抽成票提';

-- ----------------------------
-- Table structure for smile_user
-- ----------------------------
DROP TABLE IF EXISTS `smile_user`;
CREATE TABLE `smile_user`  (
                               `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                               `uid` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '用户id',
                               `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '照片',
                               `name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '真实姓名',
                               `birthday` date NULL DEFAULT NULL COMMENT '生日YYYY-MM-DD',
                               `sex` int NULL DEFAULT NULL COMMENT '性别(1：男（默认），2：女)',
                               `phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '手机号',
                               `province_id` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省key',
                               `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省',
                               `city_id` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '市key',
                               `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '市',
                               `area_id` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '区key',
                               `area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '区',
                               `address` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '详细地址',
                               `wechat` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '微信号',
                               `type` int NULL DEFAULT NULL COMMENT '代理类型（0：未审核，1：总代，2：普代，3：未认证,4：驳回审核）',
                               `org_id` bigint NULL DEFAULT NULL COMMENT '组织关联',
                               `id_card` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '身份证号',
                               `school_id` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '学校关联ID',
                               `school_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '学校名称',
                               `school_major` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '专业',
                               `identity` int NULL DEFAULT NULL COMMENT '身份（1:在校学生（默认），2已毕业）',
                               `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '标识步骤',
                               `agent` int NULL DEFAULT NULL COMMENT '1：代理开启，2：代理关闭',
                               `agent_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '组织总代id',
                               `error_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '审核失败原因',
                               `introduce` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '自我介绍',
                               `specialty1` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '擅长1',
                               `specialty2` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '擅长2',
                               `specialty3` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '擅长3',
                               `state` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '0：正常，1：黑名单',
                               `del_tag` int NULL DEFAULT NULL COMMENT '0：未删除，1：已删除',
                               `created_date` datetime NULL DEFAULT NULL,
                               `updated_date` datetime NULL DEFAULT NULL,
                               PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '小家伙用户表' ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;

-- ----------------------------
-- Table structure for smile_agent
-- ----------------------------
DROP TABLE IF EXISTS `smile_agent`;
CREATE TABLE `smile_agent`  (
                                `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                                `performance_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '演出id',
                                `ticket_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '票id',
                                `total_carry` decimal(4, 3) UNSIGNED ZEROFILL NULL DEFAULT 0.000 COMMENT '总代票提',
                                `ord_carry` decimal(4, 3) UNSIGNED ZEROFILL NULL DEFAULT 0.000 COMMENT '普代票提',
                                `del_tag` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '0未删除，1已删除',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '小家伙票种表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for smile_organization
-- ----------------------------
DROP TABLE IF EXISTS `smile_organization`;
CREATE TABLE `smile_organization`  (
                                       `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                                       `name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '组织名称',
                                       `province_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省key',
                                       `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省',
                                       `city_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '市key',
                                       `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '市',
                                       `area_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '区key',
                                       `area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '区',
                                       `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '地区(省份/地区/详细地址)',
                                       `agent_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '总代理',
                                       `del_tag` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '0：未删除，1：已删除',
                                       `created_date` datetime NULL DEFAULT NULL,
                                       `updated_date` datetime NULL DEFAULT NULL,
                                       PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '小家伙组织管理表' ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;

-- ----------------------------
-- Table structure for smile_price
-- ----------------------------
DROP TABLE IF EXISTS `smile_price`;
CREATE TABLE `smile_price`  (
                                `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
                                `performances_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '演出id',
                                `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户id',
                                `price` decimal(10, 2) NOT NULL COMMENT '打款金额',
                                `del_tag` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '0：未删除，1：已删除',
                                `created_date` datetime NULL DEFAULT NULL COMMENT '创建时间',
                                `updated_date` datetime NULL DEFAULT NULL COMMENT '修改时间',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;

-- ----------------------------
-- Table structure for smile_school
-- ----------------------------
DROP TABLE IF EXISTS `smile_school`;
CREATE TABLE `smile_school`  (
                                 `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                                 `name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '学校名称',
                                 `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '地址（省份-地区-详细地址）',
                                 `province_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省key',
                                 `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省',
                                 `city_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '市key',
                                 `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '市',
                                 `area_id` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '区key',
                                 `area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '区',
                                 `del_tag` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '0：未删除，1：已删除',
                                 PRIMARY KEY (`id`, `name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '小家伙学校管理表' ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;

-- ----------------------------
-- Table structure for smile_agent
-- ----------------------------
DROP TABLE IF EXISTS `smile_agent`;
CREATE TABLE `smile_agent`  (
                                `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                                `performance_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '演出id',
                                `ticket_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '票id',
                                `total_carry` decimal(4, 3) UNSIGNED ZEROFILL NULL DEFAULT 0.000 COMMENT '总代票提',
                                `ord_carry` decimal(4, 3) UNSIGNED ZEROFILL NULL DEFAULT 0.000 COMMENT '普代票提',
                                `del_tag` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '0未删除，1已删除',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '小家伙票种表' ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;