package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.kylin.entity.KylinFieldStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class FieldsStatusParam implements Serializable {
    @ApiModelProperty(value = "场地主键")
    private String fieldsId;

    @ApiModelProperty(value = "是否显示 0不显示 1显示", example = "1")
    private int isDisplay;

    @ApiModelProperty(value = "是否营业 0不营业 1营业中", example = "1")
    private int isBusiness;

    @ApiModelProperty(example = "", hidden = true)
    private String updatedAt;

    @JsonIgnore
    public KylinFieldStatus getFieldStatus() {
        KylinFieldStatus fieldStatus = new KylinFieldStatus();
        fieldStatus.setIsBusiness(isBusiness);
        fieldStatus.setIsDisplay(isDisplay);
        return fieldStatus;
    }
}
