package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

@Api(tags = "会员用户")
@Slf4j
@Validated
@RestController
@RequestMapping("adam/umember")
public class AdamUserMemberAdminController {
    @Autowired
    RedisUtil redisUtil;

    @RequiresPermissions("adam:umember:blk:lis")
    @ApiOperation(value = "会员黑名单UID")
    @PostMapping("blk/lis")
    public ResponseDto<List<String>> listBlack() {
        return ResponseDto.success((List<String>) redisUtil.get(AdamRedisConst.BLK_LIST_MEMBER_UID));
    }

    @RequiresPermissions("adam:umember:blk:add")
    @ApiOperation(value = "添加会员黑名单")
    @PostMapping("blk/add")
    public ResponseDto<List<String>> addBlack(@NotBlank(message = "会员ID不能为空") @RequestParam String opts) {
        String[] uidArr = opts.split(",");
        List<String> invalidList = new ArrayList<>(), existList = new ArrayList<>();
        for (String uid : uidArr) {
            if (StringUtils.isNotBlank(uid) && uid.length() < 64) {
                existList.add(uid);
            } else {
                invalidList.add(uid);
            }
        }
        List<String> blacklist = (List<String>) redisUtil.get(AdamRedisConst.BLK_LIST_MEMBER_UID);
        if (CollectionUtils.isEmpty(blacklist)) {
            blacklist = existList;
        } else {
            blacklist.addAll(existList);
        }
        if (!CollectionUtils.isEmpty(blacklist)) {
            redisUtil.set(AdamRedisConst.BLK_LIST_MEMBER_UID, blacklist);
        } else {
            log.warn("###blacklist.add:failed,invalidList:{},existList:{},opts:{}", invalidList.size(), existList.size(), opts);
        }
        return ResponseDto.success(invalidList);
    }

    @RequiresPermissions("adam:umember:blk:del")
    @ApiOperation(value = "删除会员黑名单")
    @PostMapping("blk/del")
    public ResponseDto<Object> delBlack(@NotBlank(message = "会员ID不能为空") @RequestParam String opts) {
        String[] uidArr = opts.split(",");
        List<String> blacklist = (List<String>) redisUtil.get(AdamRedisConst.BLK_LIST_MEMBER_UID);
        if (!CollectionUtils.isEmpty(blacklist)) {
            for (String uid : uidArr) {
                blacklist.remove(uid);
            }
            redisUtil.set(AdamRedisConst.BLK_LIST_MEMBER_UID, blacklist);
        }
        return ResponseDto.success();
    }
}
