package com.liquidnet.service.platform.controller.goblin.code;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/19 2:53 下午
 */

@Api(tags = "兑换码")
@Slf4j
@Validated
@RestController
@RequestMapping("code")
public class GoblinNftExCodeController {

    @Autowired
    IGoblinNftExCodeService iGoblinNftExCodeService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "根据nft兑换活动获取兑换码")
    @PostMapping("selectCodePageList")
    public ResponseDto<PageInfo<GoblinNftExCodeVo>> selectCodePageList(@RequestBody GoblinNftExCodeParam goblinNftExCodeParam){
        return ResponseDto.success(iGoblinNftExCodeService.selectCodePageList(goblinNftExCodeParam));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "兑换码主动失效")
    @PostMapping("defDrivLoseCodes/{codeIds}")
    public ResponseDto<Boolean> defDrivLoseCode(@PathVariable("codeIds")String codeIds){
        return ResponseDto.success(iGoblinNftExCodeService.defDrivLoseCode(codeIds));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "空投发送")
    @PostMapping("addAirdrop")
    public ResponseDto<Boolean> addAirdrop(@RequestBody GoblinNftExCodeParam goblinNftExCodeParam){
        return ResponseDto.success(iGoblinNftExCodeService.addAirdrop(goblinNftExCodeParam));
    }







}
